        PAGE    ,105
        TITLE   Command Line
        .MODEL  MEDIUM
;***********************************************************************
;                           COMMAND.ASM                                *
;   COMMAND(<string>) [DECLARE SUB COMMAND (A$)] is an assembled       *
; subroutine to be linked to programs compiled with Microsoft BC v.    *
; 7.0 (or later) to insert "the rest of the command line" in the       *
; Program Segment Prefix before starting another program with the "RUN * 
; <filename>" command.  This version will operate correctly for        *
; programs compiled in either the "near string" or "far string" mode.  *
;   Call with:  CALL COMMAND(<string>)                                 *
;       where <string> is the argument string to be returned by the    *
;       new program.  (If the new program was compiled from BASIC, the *
;       text string will be returned by COMMAND$ with all lower-case   *
;       letters converted to upper case.)                              *
;   If LEN(<string>) > 125, a null argument string will be inserted    *
; instead.                                                             *
;----------------------------------------------------------------------*
;               Written by M. L. Lesser, March 30, 1990                *
;    Based on the BC version 4.0 module of the same name, written for  *
; the book "Advanced QuickBASIC 4.0," published by Bantam Books, 1988. *
;                 Assembled with Microsoft MASM v. 5.1                 *
;***********************************************************************

EXTRN StringAddress:FAR                 ;"Mixed language" functions
EXTRN StringLength:FAR                  ; added to BC 7.0 libraries

.CODE
        PUBLIC COMMAND
COMMAND PROC
; Save critical registers used:
        PUSH    BP
        MOV     BP,SP
        PUSH    DS
        PUSH    SI
        PUSH    DI
; Get string-argument length first:
        PUSH    6[BP]                   ;Argument for StringLength
        CALL    StringLength            ; (offset of string descriptor)
        PUSH    AX                      ;Function return in AX
; Get address of string:
        PUSH    6[BP]
        CALL    StringAddress           ;Function returns far address
        MOV     DS,DX                   ; pointer in DX:AX
        MOV     SI,AX
; Get PSP segment address:
        MOV     AH,51H                  ;Undocumented DOS call
        INT     21H                     ;  returns PSP segment address
        MOV     ES,BX                   ;  in BX
        MOV     DI,80H                  ;Start of argument pointer
; Insert string in command line in proper form:
        POP     CX                      ;String length
        OR      CX,CX                   ;Is it null string?
        JZ      NULL
        CMP     CX,7DH                  ;Is it within length limit?
        JA      NULL                    ;If not, replace with null
        MOV     AL,CL                   ;Number of bytes in string
        INC     AL                      ;Add one for leading <SP>
        STOSB                           ;Store command-line byte count
        MOV     AL,' '                  ;Insert leading <SP>
        STOSB
        REP     MOVSB                   ;Move text of <string>
DONE:   MOV     AL,0DH                  ;Add trailing <CR>
        STOSB
        POP     DI
        POP     SI
        POP     DS
        POP     BP
        RET     2
NULL:   XOR     AL,AL                   ;Forces null command line
        STOSB
        JMP     DONE
COMMAND ENDP

        END
