/*	v_scroll.c */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_scroll_region( viewport *v, int up, int to_left,
				    int left, int top, int right, int bottom )
{
      /* Move the text in the viewport "to_left" lines to the left and up
       * "up" lines. Go right if "to_left" is negative, down if "up" is
       * negative. Cursor position is not changed. Newly opened space
       * is filled with blanks. This function may not be used to clear
       * the viewport--false is returned (and no movement occurs along
       * that axis) if the requested movement is >= the viewpoint
       * dimension. Use v_clear() to clear a viewport.
       *
       * The scrolled region is bounded by by the window-relative left and right
       * columms, and top and bottom rows. You can use 0,0,100,100 for these
       * last four arguments if you want to scroll the whole window because
       * v_scroll_region truncates the box size down to the viewport size
       * if necessary.
       */

    int this_many, from, to, ncols, nrows;
    int value = 1;				/* return value */

    if( v->magic != VMAGIC )
	return 0;
    if( v->inactive )
	v_open( v );

    left  = v->col + left;		/* figure out the cooridinates  */
    top   = v->row + top;		/* of the upper left corner,    */
    ncols = right-left +1;		/* and the size of the affected */
    nrows = bottom-top +1;		/* region.			*/

    if( (left >= v->ncols) || (top >= v->nrows) ) /* bounding box is outside */
	return 0;				  /* window entirely.	     */

    if( left + ncols > v->ncols )	/* if the bounding box is outside  */
    {					/* of the window, truncate it down */
	ncols = v->ncols - left ;	/* to fit.			   */
	value = 0;
    }
    if( top  + nrows > v->nrows )
    {
    	nrows = v->nrows - top ;
	value = 0;
    }

    /* Do horizontal motion first, then vertical. */

    if( to_left )
    {
	this_many = ncols - abs(to_left) ;
	from      = (to_left > 0) ? (left + to_left):(left	    );
	to	  = (to_left > 0) ? (left          ):(left - to_left);

	if( this_many < 0 )
	    value = 0;
	else if( this_many > 0 )
	    movetext( from+1, top+1, from+this_many, top+nrows,
						    to +1, top +1 );

	_v_fill_scr( VINIT_CHAR | (v->bcolor << 4 | v->fcolor) << 8,
		       top, to_left > 0 ? left + this_many : left,
				   nrows, ncols - this_many );
    }
    if( up )
    {
	this_many = nrows - abs( up ) ;
	from      = (up > 0) ? (top +  up) : (top      );
	to	  = (up > 0) ? (top      ) : (top -  up);

	if( this_many < 0 )
	    value = 0;
	else if( this_many > 0 )
	    movetext( left+1, from+1, left+ncols, from+this_many,
						    left+1, to+1 );

	_v_fill_scr( VINIT_CHAR | (v->bcolor << 4 | v->fcolor) << 8,
			up > 0 ? top + this_many : top , left,
				    nrows - this_many, ncols );
    }
    return value;
}

