' CurDir.Bas - Support module to contain the CurDir$ function.

' $INCLUDE: 'CURDIR.BI'
' $INCLUDE: 'QB.BI'


FUNCTION CurDir$
' CurDir$ -     Returns a string containing the current working
'               drive and directory.

DIM Regs AS RegTypeX
DIM cwdTmp1 AS STRING * 64
DIM cwDrv AS INTEGER

Regs.AX = &H1900             ' get current disk
InterruptX &H21, Regs, Regs

cwDrv = Regs.AX AND &HFF

LSET cwdTmp1 = ""

Regs.AX = &H4700             ' get current working direcory
Regs.DX = 0                  ' specify current drive
Regs.DS = VARSEG(cwdTmp1)
Regs.SI = VARPTR(cwdTmp1)
InterruptX &H21, Regs, Regs

' Construct the final current directory string.
cwdTmp2$ = CHR$(cwDrv + &H41) + ":\" 
CurDir$ = cwdTmp2$ + MID$(cwdTmp1, 1, INSTR(cwdTmp1, CHR$(0)) - 1)

END FUNCTION

