;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.model medium, Basic
.code

;============================================================================
; DECLARE SUB SETBLINK (BYVAL Status%)
; Purpose:
;       Toggles background blinking/intensity for MONO, CGA, EGA, VGA
;       allows use of background colors that would otherwise flash
; Parameters:
;       =  0 turn off blinking, enable intensity
;       <> 0 to turn it on again
; Returns:
;       nothing
;============================================================================

EVEN
SETBLINK Proc FAR BASIC STATUS:ptr word
	Xor             BX,BX
	Mov             ES,BX              ; set ES to BIOS RAM

EGATest:
	Mov             AX,1200h           ; read EGA/VGA config
	Mov             BX,10h
	Int             10h
	Cmp             BL,10h             ; EGA changes BL from 10h
	Je              CGA_Adjust         ; no change in BL so have CGA/MDA
	Cmp             CL,6               ; determine primary monitor type
					   ; EGA/VGA is primary monitor if CL
					   ; is greater or = to 6
	JAE             EGA_Adjust         ; primary adapter EGA/VGA

CGA_Adjust:                                ; not a VGA/EGA or inactive
					   ; so treat as a CGA/Mono
	Mov             BX,STATUS          ; read input number
	Mov             DX,ES:[0463h]      ; read base port address for CRT
	ADD             DL,04h             ; CGA/Mono independent code
	Mov             AL,ES:[0465h]      ; read current setting of CRT mode
					   ; register
	OR              BX,BX              ; see if user input is 0
	JZ              SETB1              ; if zero
	OR              AL,20h             ; set bit
	Jmp             Short SETB2
SETB1:
	And             AL,0DFh            ; clear bits
SETB2:
	Out             DX,AL              ; send to CRT corrected settings
	Mov             ES:[0465h],AL      ; write back current CRT mode
	Jmp             Short SETB_END

EGA_Adjust:

	Mov             BX,STATUS          ; read input number
	OR              BX,BX              ; see if user input is 0
	JZ              SETB3              ; if 0 then jump forward
	Mov             BL,01              ; set bit for blinking
SETB3:
	Mov             AX,1003h           ; do it to EGA/VGA
					   ; if BL = 1 then blinking enabled
					   ; if BL = 0 then intensity enabled
	Int             10h
SETB_END:                                  ; quit
	Ret                                ; MASM cleans up stack
SETBLINK        ENDP
END
