








              Quarterdeck Technical Note

              Subject:  Patching QEMM-386 5.10, 5.11, and 
              5.12 to resolve problems with programs that make 
              EMS 4.0 calls to move or exchange zero-length 
              memory regions.  

                Background: The EMS (Expanded Memory 
              Specification) 4.0 provides a call (function 24) 
              which programs can make to move information from 
              one region of memory to another, or to exchange 
              information between two regions of memory.  

              Users of QEMM-386 versions 5.10 through 5.12 may 
              experience system instability when a program makes 
              the Function 24 EMS call to move or exchange a 
              region of memory that is zero bytes in length.  The 
              symptom is likely to be a system crash.  There is 
              no good reason to use Function 24 on a region of 
              length zero, but such a situation may occur when a 
              program uses the same subroutine to implement 
              Function 24 in a variety of different situations.

                Users of versions of QEMM-386 after version 5.12 
              should not experience this problem.  In the 
              meantime, QEMM-386 can be patched to eliminate the 
              problem.  

                The following procedure is intended to prevent 
              system crashes when EMS 4.0 Function 24 is used to 
              move or exchange zero-length regions of memory 
              under QEMM-386.  This procedure is for use with 
              QEMM-386 versions:

                      5.10 
                      5.11 
                      5.12

              ***************************************************
              
                Do NOT use this patch for QEMM-386 5.0 or 
              earlier, or on any version of QEMM-386 later than 
              5.12.  If you are in doubt, go to the directory 
              where the QEMM-386 files are located and check the 
              date on the QEMM386.SYS file by issuing the DOS 
              command:

                        DIR QEMM386.SYS

              If the date on the file is

                        5:10 am 
                        5:11 am 
                        5:12 am

              then use the patch in this section. If there is no 
              QEMM386.SYS file in this directory, or if the date 
              on the file is later than 5:12 am, then you 
              probably have an earlier or later version of QEMM-
              386, and this patch is not appropriate.  

              *************************************************** 

                1) Make a copy of the QEMM386.SYS file in your 
              QEMM directory.  We are about to alter your current 
              copy of QEMM386.SYS; the copy you make will serve 
              as a backup in case this operation fails.

                    COPY C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                2) Go to the DOS directory on the hard disk and 
              type:

                  DEBUG C:\QEMM\QEMM386.SYS

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                Hit the Enter key; you should see the DEBUG 
              prompt, which is a hyphen.

                3) At the DEBUG prompt, type:

                  S 100 L F000 8B CB 0B DA 74 F0

                Hit the Enter key; DEBUG should return a segment 
              address and an offset:

                  xxxx:yyyy

                4) At the DEBUG prompt again, use the segment 
              address and offset that was just returned to give 
              the DEBUG command:

                  E xxxx:yyyy 8B CB 0B DA 74 22
   
                The address that DEBUG returned in step 3 should 
              be used in place of the address xxxx:yyyy, which we 
              use as an example.  Hit the Enter key; the DEBUG 
              prompt should return in a moment.


                5) At the DEBUG prompt, type

                  W

                Hit the Enter key; DEBUG will announce that it is 
              writing a certain number of bytes, then it will 
              return the DEBUG prompt.

                6) At the DEBUG prompt, type

                  Q

                Hit the Enter key to exit DEBUG and return to 
              DOS.  

                7) To double-check your patch, type the following 
              from the DOS prompt in your DOS directory:

                  COMP C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

               (If your QEMM386.SYS is not located in the QEMM
              directory of the C: drive, change the path
              accordingly.)

                Hit the Enter key.  COMP should return:


                            C:QEMM386.SYS and C:QEMM386.OLD

                            Compare error at OFFSET xxxx
                            File 1 = 22

                            File 2 = F0

                            Eof mark not found

                            Compare more files (Y/N)?

                The value xxxx after OFFSET will vary from 
              version to version of QEMM 5.1, but the rest of the 
              message should be the same: it tells us that 
              there is exactly one byte difference between the 
              files, and the differing byte is 22 in QEMM386.SYS
              and F0 in QEMM386.OLD.  If COMP returns the 
              message:

                            Files compare ok  

              ...then you probably failed to use DEBUG's W 
              command to save your change, or you have compared 
              the wrong files.  If COMP returns more than one 
              compare error, or if the bytes returned by the 
              compare error don't match those in the above 
              example, the procedure has failed.  In this case, 
              use the DOS command:

                  COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

              ... to restore the original file, and try again.


              If the patch was successful, you should now reboot 
              the system and test the patched version of QEMM-
              386.  
              

              --------------------------------------------------

                If the system fails after you perform this patch, 
              you can follow the instructions in the 
              "Installation" section of your QEMM-386 manual to 
              recover without resorting to a boot floppy.  After 
              your system is booted successfully, copy the backup 
              of QEMM-386 that you made back to its original 
              name with the following DOS command:

                  COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                You may then wish to try the above procedure 
              again, in case a mistake was made.

             * * *   E N D   O F   F I L E    * * *
