/*  Demo.c  -  A demo program using pc curses. The program illustrate
    the use of colours for text output.   */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <bios.h>
#include <memory.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include "curses.h"

//
//  The Australian map
//
char    *AusMap1[16] =
{   
    "           A           A ",
    "    N.T. AAAAA       AAAA ",
    "     AAAAAAAAAAA  AAAAAAAA ",
    "   AAAAAAAAAAAAAA#AAAAAAAAAA Qld.",
    "###########AAAAAA#AAA######## ",
    "AAAAAAAAAA############AAAAAAAA ",
    " AAAAAAAAA#AAAAAAAAAA#####AAA ",
    "   AAAAAAA#AAAAAAAAAA#AAAA## N.S.W.",
    "W.A. AAAAA#AAA      A#AAAA Vic.",
    "       AAA   S.A.     AA",
    "                           A  Tas.",
    ""
};

char    *AusMap2[16] =
{   
    "           A           A ",
    "    N.T. AAAAA       AAAA ",
    "     AAAAAAAAAAA  AAAAAAAA ",
    "   AAAAAAAAAAAAAA#AAAAAAAAAA Qld.",
    "###########AAAAAA#AAA######## ",
    "AAAAAAAAAA############AAAAAAAA ",
    " AAAAAAAAA#AAAAAAAAAA#####AAA ",
    "   AAAAAAA#AAAAAAAAAA#AAAA## N.S.W.",
    "W.A. AAAAA#AAA      A#AAAA Vic.",
    "       AAA   S.A.     AA",
    "                           A  Tas.",
    ""
};

//
//  Funny messages
//
#define NMESSAGES   6

char    *messages[] =
{   
    "Hello from the Land Down Under",
    "The Land of crocs. and a big Red Rock",
    "Where the sunflower runs along the highways",
    "the dusty red roads lead one to loneliness",
    "Blue sky in the morning and",
    "freezing nights and twinkling stars",
    ""
};

//extern  void    SubWinTest(WINDOW*);
//extern  void    BouncingBalls(WINDOW*);
extern  int     WaitForUser(void);

//
//  Bouncing balls
//
class   balls
{
private:
    int     w, h, x, y, xd, yd, savec, ch, attr;
public:
    //
    //  Initialise the ball
    //
    void BallSetup(WINDOW *win, int c, int a)
    {   w  = win->_maxx;
        h  = win->_maxy;
        x  = 2 + rand() % (w - 4);
        y  = 2 + rand() % (h - 4);
        xd = rand()%2; 
        yd = rand()%2;
        ch = c;
        attr = a;
    }
    //
    //  Do a move for the ball.
    //
    MoveBall(WINDOW *win)
    {
        if(x <= 1 || x >= w - 2)
            xd = xd ? 0 : 1;
        x = xd > 0 ? ++x : --x;
        if(y <= 1 || y >= h - 2)
            yd = yd ? 0 : 1;
        y = yd > 0 ? ++y : --y;

        savec = wgetatpos(win, y, x);
        wattrset(win, attr);
        mvwaddch(win, y, x, ch);
        wmove(win, 0, 0);
        wrefresh(win);
        return  0;
    }
    //
    //  Restore background pixel
    //
    void RestorePixel(WINDOW *win)
    {
        wputatpos(win, y, x, savec);
    }
};

//
//  Bouncing the balls about
//
BouncingBalls(WINDOW *win)
{
balls   *theballs;
int     i, nballs, n;
char    chars[5] =  { '@', '$', '*', 'O', '<' };
int     attrs[5] =  { F_RED     |   B_BLUE,
                      F_MAGENTA |   B_GRAY,
                      F_CYAN    |   B_RED,
                      F_GRAY    |   B_BLUE,
                      F_GREEN   |   B_MAGENTA
                    };
    
    nballs   = 1 + rand()%20;
    theballs = (balls *)malloc(nballs*sizeof(balls));
                            // Bounce the balls around
    for(i=0; i < nballs; ++i)
    {   n = rand() % 5;
        theballs[i].BallSetup(win, chars[n], attrs[n]);
    }
    
    do
    {   for(i=0; i < nballs; ++i)
            theballs[i].MoveBall(win);
        for(i=nballs-1; i >= 0; --i)
            theballs[i].RestorePixel(win);
        delay(150);
    }
    while(!bioskey(1));     // Bounce them
    bioskey(0);             // get rid of the input chracter

    free((void *)theballs); // free all memory
    return  0;
}

//
// Test sub windows
//
SubWinTest(WINDOW *win1)
{
int     w, h, sw, sh, bx, by;
WINDOW  *swin1, *swin2, *swin3;

    w  = win1->_maxx;
    h  = win1->_maxy;
    bx = win1->_begx;
    by = win1->_begy;
    sw = w / 3;
    sh = h / 3;
    if((swin1 = subwin(win1, sh, sw, by+3, bx+5)) == NULL)
        return  1;
    if((swin2 = subwin(win1, sh, sw, by+4, bx+8)) == NULL)
        return  1;
    if((swin3 = subwin(win1, sh, sw, by+5, bx+11)) == NULL)
        return  1;
    wattron(swin1, B_BLUE    | F_RED);
    werase(swin1);
    mvwaddstr(swin1, 0, 3, "Sub-window 1");
    wrefresh(swin1);

    wattron(swin2, B_MAGENTA | F_CYAN);
    werase(swin2);
    mvwaddstr(swin2, 0, 3, "Sub-window 2");
    wrefresh(swin2);

    wattron(swin3, B_GREEN   | F_BROWN);
    werase(swin3);
    mvwaddstr(swin3, 0, 3, "Sub-window 3");
    wrefresh(swin3);

    delwin(swin1);
    delwin(swin2);
    delwin(swin3);
    WaitForUser();
    return  0;
}

//
//  Main driver
//
main(void)
{
WINDOW  *win;
int     w, x, y, i, j, c, len;
time_t  t;
char    buffer[80], *message;
int     width, height;
int     save[80];
void    trap(void);

    initscr();
    signal(SIGINT, (void (* _Cdecl)(int))trap);
    width  = 48;
    height = 13;                // Create a drawing window
    win = newwin(height, width, (_LINES-height)/2, (_COLS-width)/2);
    if(win == NULL)
    {   endwin();
        return 1;
    }

    while(1)
    {   wattrset(win, F_GRAY | B_BLUE);
        werase(win);

        wattrset(win, F_RED | B_RED);
        box(win, '-', '+');
        wrefresh(win);
                                // Do ramdom output of a character
        wattrset(win, F_GRAY | B_BLUE);
        c = 'a';
        for(i=0; i < 5000; ++i)
        {   x = rand() % (width-2)  + 1;
            y = rand() % (height-2) + 1;
            mvwaddch(win, y, x, c);
            wrefresh(win);
            if(kbhit())
                break;
            if(i == 2000)
            {   c = 'b';
                wattron(win, F_CYAN | B_BROWN);
            }
        }

        SubWinTest(win);
                                // Erase and draw green window
        wattrset(win, B_GREEN | F_BROWN | A_HIGH);
        werase(win);
        wrefresh(win);
                                // Draw RED bounding box
        wattrset(win, F_RED | B_RED);
        box(win, ' ', ' ');
        wrefresh(win);
                                // Display Australia map
        wattrset(win, B_GREEN | F_BROWN | A_HIGH);
        i = 0;
        while(*AusMap1[i])
        {   mvwaddstr(win, i+1, 8, AusMap1[i]);
            wrefresh(win);
            delay(100);
            ++i;
        }

        wattrset(win, B_GREEN | F_BROWN);
        i = 0;
        while(*AusMap2[i])
        {   
        char  *p = AusMap2[i];
            j = 8;
            while(*p)
            {   if(*p == '#')
                    mvwaddch(win, i+1, j, *p);
                ++j; ++p;
            }
            ++i;
        }
        wrefresh(win);

        wattrset(win, A_BLINK| F_BLUE | B_GRAY);
        mvwaddstr(win, height-2, 12, " PC curses for Ansi-C ");
        wrefresh(win);

                                // Draw running messages
        wattrset(win, F_BROWN | B_GRAY);
        message = messages[0];
        len = strlen(message);
        j = 0;
        i = 2;
        w = width-2;
        while(j < NMESSAGES)
        {   strncpy(buffer, message, w - i);
            buffer[w-i] = 0;
            mvwaddstr(win, height/2, i, buffer);
            if(w - i < len)
            {   memset(buffer, ' ', i);
                strcpy(buffer, message + (w - i));
                buffer[strlen(buffer)]   = ' ';
                buffer[i-2] = '\0';
                mvwaddstr(win, height/2, 2, buffer);
            }                
            wrefresh(win);
            if(kbhit()) 
            {   bioskey(0);
                break;
            }
            mvwaddch(win, height/2, i, ' ');
            i = ++i % w;
            if(i < 2)
            {   message = messages[++j%NMESSAGES];
                memset(buffer, ' ', w-2);
                buffer[w-2] = 0;
                mvwaddstr(win, height/2, 2, buffer);
                i = 2;
            }
            delay(300);
        }

        j = 0;
                                //  Draw running As across in RED
        wattron(win, B_GREEN|F_RED);
        for(i=2; i < width - 4; ++i)
        {   c = wgetatpos(win, 4, i);
            save[j++] = c;
            c = c & 0x7f;
            mvwaddch(win, 4, i, c);
        }
        wrefresh(win);

                                // Put a message up wait for a key
        i = height-2;
        wattrset(win, F_BLUE | B_GRAY);
        mvwaddstr(win, i, 12, " Type a key to continue ");
        wrefresh(win);

        if(WaitForUser() == 0x1b)
            break;

        j = 0;                  // Restore the old line 
        for(i=2; i < width - 4; ++i)
            wputatpos(win, 4, i, save[j++]);
        wrefresh(win);

        BouncingBalls(win);
                                // Put a message up wait for a key
        i = height-2;
        wattrset(win, F_BLUE | B_GRAY);
        mvwaddstr(win, i, 12, " Hit ESC key to exit ...");
        wrefresh(win);
        if(WaitForUser() == 0x1b)
            break;
    }
exit:
wattrset(win, A_NORMAL);
    x = (win->_maxx - strlen(" Demo written by Van Dao MAI "))/2;
    mvwaddstr(win, i-3, x, " Demo written by Van Dao MAI ");
    mvwaddstr(win, i-2, x, "     Wollongong University   ");
    mvwaddstr(win, i-1, x, "          AUSTRALIA          ");
    wattron(win,   B_GREEN);
    mvwaddstr(win, i,   x, "                             ");
    wrefresh(win);
    endwin();
    return 0;
}

//
//  Wait for user
//
WaitForUser()
{
time_t  t;

    t = time((time_t *)0);
    while(1)                         
    {   if(bioskey(1))
        {   if((bioskey(0) & 0x7f) == 0x1b)
                return  0x1b;
            else
                return  0;
        }
        if(time((time_t *)0) - t > 3)
            return  0;
    }
}

//
//  Trap interrupt
//
void trap(void)
{
    endwin();
    exit(0);
}

//  End of demo.c
