#ifdef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	def_prog_mode

#ifndef	NDEBUG
char *rcsid_def_prog = "$Header: c:/curses/portable/RCS/def_prog.c%v 2.0 1992/11/15 03:28:48 MH Rel $";
#endif




/*man-start*********************************************************************

  def_prog_mode()	- Save terminal mode

  X/Open Description:
 	Save the current terminal modes as the "program" (in CURSES) or
 	"shell" (not in CURSES) state for use by the reset_prog_mode()
 	and reset_shell_mode() functions.  This is done automatically by
 	initscr().

  PDCurses Description:
 	PDCurses maintains a WINDOW* that contains the original user's
 	screen upon startup.  This might be useful for returning the
 	user's environment to its (near) original state.

 	This is unimplemented at this time.

  X/Open Return Value:
 	The def_prog_mode() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int def_prog_mode( void );
 	X/Open Dec '88	int def_prog_mode( void );
 	BSD Curses
        SYS V Curses    int def_prog_mode( void );

**man-end**********************************************************************/

int	def_prog_mode(void)
{
#ifdef	FLEXOS
	_flexos_16bitmode();
#endif
	c_pr_tty.been_set = TRUE;
#if 	defined DOS || defined OS2
#  if	SMALL || MEDIUM
	movedata( FP_SEG(&_cursvar),		FP_OFF(&_cursvar),
		  FP_SEG(&c_pr_tty.saved), 	FP_OFF(&c_pr_tty.saved),
		  sizeof(SCREEN) );

#  else
	memcpy(&c_pr_tty.saved, &_cursvar, sizeof(SCREEN));
#  endif
#endif

	return( OK );
}
