#include <stdlib.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	newwin

#ifndef	NDEBUG
char *rcsid_newwin = "$Header: c:/curses/portable/RCS/newwin.c%v 2.0 1992/11/15 03:29:28 MH Rel $";
#endif




/*man-start*********************************************************************

  newwin()	- create new window

  X/Open Description:
 	Create a new window with the given number of lines, nlines and
 	columns, ncols. The upper left corner of the window is at line
 	begy, column begx. If either nlines or ncols is zero,
 	they will be defaulted to LINES - begy and COLS - begx. A
 	new full-screen window is created by calling newwin(0, 0, 0, 0).

  PDCurses Description:
 	PDCurses allows developers to provide a hook into the malloc
 	package used.  See initscr(3c) for more details.

 	Also, when a window is created, it uses the default screen
 	colors and attributes in effect when initscr() was called.

  X/Open Return Value:
 	On success the newwin() function returns a pointer to the new
 	WINDOW structure created. On failure the function returns a
 	null pointer.

  PDCurses Errors:
 	The following conditions are errors:
 		o  number of lines   == 0,
 		o  number of columns == 0,
 		o  failure to allocate memory for the window structure

  Portability:
 	PDCurses	WINDOW* newwin(int nlines,int ncols,int begy,int begx);
 	X/Open Dec '88	WINDOW* newwin(int nlines,int ncols,int begy,int begx);
 	BSD Curses	WINDOW* newwin(int nlines,int ncols,int begy,int begx);
 	SYS V Curses	WINDOW* newwin(int nlines,int ncols,int begy,int begx);

**man-end**********************************************************************/

WINDOW*	newwin(int nlines, int ncols, int begy, int begx)
{
extern	void*	(*mallc)( size_t );
extern	void*	(*callc)( size_t, size_t );
extern	void	(*fre)( void* );

	WINDOW*	win;
	chtype*	ptr;
	int	i;
	int	j;

	if (nlines == 0)	nlines = LINES - begy;
	if (ncols  == 0)	ncols  = COLS  - begx;

	if ((win = PDC_makenew(nlines, ncols, begy, begx)) == (WINDOW *) NULL)
		return( (WINDOW *)NULL );

	for (i = 0; i < nlines; i++)
	{
		/*
		 * make and clear the lines
		 */
		if ((win->_y[i] = (*callc)(ncols, sizeof(chtype))) == NULL)
		{
			for (j = 0; j < i; j++)
			{
				/*
				 * if error, free all the data
				 */
				(*fre)(win->_y[j]);
			}
			(*fre)(win->_firstch);
			(*fre)(win->_lastch);
			(*fre)(win->_y);
			(*fre)(win);
			return( (WINDOW *)NULL );
		}
		else
		{
			for (ptr = win->_y[i];
			     ptr < win->_y[i] + ncols;)
			{
				/*
				 * Retain the original screen attributes...
				 */
				*ptr++ = _cursvar.blank;
			}
		}
	}
	return( win );
}
