#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	touchline

#ifndef	NDEBUG
char *rcsid_touchlin = "$Header: c:/curses/portable/RCS/touchlin.c%v 2.0 1992/11/15 03:29:18 MH Rel $";
#endif





/*man-start*********************************************************************

  touchline()	- touch line in window

  PDCurses Description:
 	Similar to touchwin(), but less drastic.

 	Throw away all optimisation information about which parts of the
 	window (well, lines) have been touched, by pretending that the
 	entire line(s) has been drawn on.

  PDCurses Errors:
 	The touchline() function returns OK on success and ERR on error.

 	It is an error to pass a NULL window.

 	It is also an error to specify a line outside the boundaries of
 	the passed window or if the start line plus the number of lines
 	exceeds the boundary of the window.

  Portability:
 	PDCurses	
 	SysV Curses	
 	BSD Curses	

**man-end**********************************************************************/

int	touchline(WINDOW *w, int start,int num)
{
	register int i;

	if (w == (WINDOW *)NULL)
		return( ERR );

	if  (start > w->_maxy || start + num > w->_maxy)
		return( ERR );
	for(i=start;i<start+num;i++)
	   {
		w->_firstch[i] = 0;
		w->_lastch[i] = w->_maxx - 1;
	   }
	return( OK );
}
