#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	touchwin

#ifndef	NDEBUG
char *rcsid_touchwin = "$Header: c:/curses/portable/RCS/touchwin.c%v 2.0 1992/11/15 03:29:18 MH Rel $";
#endif




/*man-start*********************************************************************

  touchwin()	- touch window

  X/Open Description:
 	Throw away all optimisation information about which parts of the
 	window have been touched, by pretending that the entire window has
 	been drawn on.  This is sometimes necessary when using overlapping
 	windows, since a change to one window will affect the other window,
 	but the records of which lines have been changed in the other
 	window will not reflect the change.

  PDCurses Description:
 	No additional functionality in the PDCurses library.

  X/Open Return Value:
 	The touchwin() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a NULL window.

  Portability:
 	PDCurses	int touchwin( WINDOW* win );
 	SysV Curses	int touchwin( WINDOW* win );
 	BSD Curses	int touchwin( WINDOW* win );
 	X/Open Dec '88	int touchwin( WINDOW* win );

**man-end**********************************************************************/

int	touchwin(WINDOW *win)
{
	int	y;
	int	maxy;
	int	maxx;

	if (win == (WINDOW *)NULL)
		return( ERR );

	maxy = win->_maxy - 1;
	maxx = win->_maxx - 1;

	for (y = 0; y <= maxy; y++)
	{
		win->_firstch[y] = 0;
		win->_lastch[y] = maxx;
	}
	return( OK );
}
