#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	typeahead

#ifndef NDEBUG
char *rcsid_typeahea = "$Header: c:/curses/portable/RCS/typeahea.c%v 2.0 1992/11/15 03:29:19 MH Rel $";
#endif

extern	short	c_pindex;		/* putter index			*/
extern	short	c_gindex;		/* getter index			*/
extern	short	c_ungind;		/* wungetch() push index	*/
extern	chtype	c_ungch[NUNGETCH];	/* array of ungotten chars	*/
extern	WINDOW*	_getch_win_;

/*man-start*********************************************************************

  typeahead()	- check for type-ahead

  X/Open Description:
 	The curses package does the "line-breakout optimisation" by
 	looking for type-ahead periodically while updating the screen.
 	If input is found, the current update will be postponed until
 	refresh() or doupdate() are called again.  This allows faster
 	response to commands typed in advance.  Normally, the input FILE
 	pointer passed to newterm(), or stdin in the case when initscr()
 	was called, will be used to do this type-ahead checking.  The
 	typeahead() routine specified that the file descriptor fd is to
 	be used to check for type-ahead instead.  If fd is -1, then no
 	type-ahead checking will be done.

  PDCurses Description:
 	Some early versions of the library (1.5beta) may have had an
 	improper interface declaration.  e.g. bool typeahead( void );
 	rather than the X/Open specified bool typeahead( FILE* fd );.

 	FYI:  Under PDCurses, the passed file handle fd is ignored.

  X/Open Return Value:
 	The typeahead() routine returns TRUE if keyboard input is pending
 	otherwise FALSE is returned.

  Portability:
 	PDCurses	bool typeahead( FILE* fd );
 	SysV Curses	
 	BSD Curses	
 	X/Open Dec '88	bool typeahead( FILE* fd );

**man-end**********************************************************************/

bool	typeahead( FILE* fd )
{
#ifdef	TC
#  pragma argsused
#endif
	if (c_ungind)
		return (TRUE);			/* ungotten char */
	if (c_pindex > c_gindex)
		return (TRUE);			/* buffered char */
	if (_cursvar.raw_inp)
		return((bool)PDC_check_bios_key());/* raw mode test */

	return((bool)PDC_check_bios_key());	/* normal mode test */
}
