#include <stdarg.h>
#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wprintw

#ifndef NDEBUG
char *rcsid_wprintw = "$Header: c:/curses/portable/RCS/wprintw.c%v 2.0 1992/11/15 03:29:33 MH Rel $";
#endif





/*man-start*********************************************************************

  wprintw()	- formatted write to a window

  X/Open Description:
 	The printw routine adds a string to the default window
 	starting at the current cursor position.  This routine causes
 	the string that would normally be output by printf to be
 	output by addstr.

 	The routine wprintw adds a string to the specified window
 	starting at the current cursor position.  This routine causes
 	the string that would normally be output by printf to be
 	output by waddstr.

 	The routine mvprintw adds a string to the default window
 	starting at the specified cursor position.  This routine
 	causes the string that would normally be output by printf to
 	be output by addstr.

 	The routine mvwprintw adds a string to the specified window
 	starting at the specified cursor position.  This routine
 	causes the string that would normally be output by printf to
 	be output by waddstr.

 	All these routines are analogous to printf.  It is advisable
 	to use the field width options of printf to avoid leaving
 	unwanted characters on the screen from earlier calls.

  PDCurses Description:
 	The old Bjorn Larssen code for the 68K platform has been removed
 	from this module.

  X/Open Return Value:
 	The printw() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int wprintw( WINDOW* win, char *fmt, ... );
 	X/Open Dec '88	int wprintw( WINDOW* win, char *fmt, ... );
 	BSD Curses	int wprintw( WINDOW* win, char *fmt, ... );
 	SYS V Curses	int wprintw( WINDOW* win, char *fmt, ... );

**man-end**********************************************************************/

int	wprintw(WINDOW * win, char *fmt,...)
{
	int	retval = ERR;
	va_list args;

	if (win == (WINDOW *)NULL)
		return (retval);

	va_start(args, fmt);
	vsprintf(c_printscanbuf, fmt, args);
	va_end(args);
	if (waddstr(win, c_printscanbuf) == ERR)
		return (retval);
	retval = (strlen(c_printscanbuf));
	return (retval);
}
