#define	CURSES_LIBRARY	1
#include <curses.h>
#undef wrefresh

#ifndef	NDEBUG
char *rcsid_wrefresh = "$Header: c:/curses/portable/RCS/wrefresh.c%v 2.0 1992/11/15 03:29:28 MH Rel $";
#endif




/*man-start*********************************************************************

  wrefresh()	- refresh window

  X/Open Description:
 	The routine wrefresh copies the named window to the physical
 	terminal screen, taking into account what is already there in
 	order to optimize cursor movement.

 	The routine refresh does the same, using stdscr as a default
 	screen.

 	These routines must be called to get any output on the
 	terminal, as other routines only manipulate data structures.

 	Unless leaveok has been enabled, the physical cursor of the
 	terminal is left at the location of the window's cursor.

  X/Open Return Value:
 	The wrefresh() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int wrefresh( WINDOW* win );
 	X/Open Dec '88	int wrefresh( WINDOW* win );
 	BSD Curses	int wrefresh( WINDOW* win );
 	SYS V Curses	int wrefresh( WINDOW* win );

**man-end**********************************************************************/

int	wrefresh(WINDOW *win)
{
	if (win == (WINDOW *)NULL)	return( ERR );
	if (win->_flags & _PAD)	return( ERR );

	if (win == curscr)
		curscr->_clear = TRUE;
	else	
		wnoutrefresh(win);
	doupdate();
	return( OK );
}
