#define	CURSES_LIBRARY	1
#define NEEDS_OS2       1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__getcbrk = "$Header: c:/curses/private/RCS/_getcbrk.c%v 2.0 1992/11/15 03:24:20 MH Rel $";
#endif

#ifdef OS2
#  if defined(CURSES__32BIT__) || defined (CSET2)
#     include <signal.h>
#  else
#     define INCL_DOSSIGNALS
#     define INCL_NOCOMMON
#     include <bsedos.h>
#  endif
#endif


/*man-start*********************************************************************

  PDC_get_ctrl_break()	- return OS control break state

  PDCurses Description:
 	This is a private PDCurses routine.

 	Returns the current OS Control Break Check state.

  PDCurses Return Value:
 	DOS:
 		This function returns TRUE on if the Control Break
 		Check is enabled otherwise FALSE is returned.

 	FLEXOS:
 		This function returns TRUE on if the Keyboard Mode
 		allows a break to bre reported otherwise FALSE is returned.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	bool	PDC_get_ctrl_break( void );

**man-end**********************************************************************/

bool	PDC_get_ctrl_break(void)
{
#ifdef	FLEXOS
	return ((kbmode & 0x01) ? TRUE : FALSE);
#endif
#ifdef	DOS
	regs.h.ah = 0x33;
	regs.h.al = 0x00;
	int86(0x21, &regs, &regs);
	return ((bool) regs.h.dl);
#endif
#ifdef	OS2
#  if defined(CURSES__32BIT__) || defined(CSET2)
	void (*oldAction) (int);
	oldAction = signal (SIGINT, SIG_DFL);
	if (oldAction == SIG_ERR) return FALSE;
	else signal (SIGINT, oldAction);
	return (oldAction != SIG_IGN);
#  else
	PFNSIGHANDLER oldHandler, oldHandler1;
	USHORT oldAction, oldAction1;
	/* get the current state, and set to ignore */
	DosSetSigHandler((PFNSIGHANDLER) NULL, &oldHandler, &oldAction,
		SIGA_IGNORE, SIG_CTRLBREAK);
	/* restore the previous state */
	DosSetSigHandler(oldHandler, &oldHandler1, &oldAction1,
		oldAction, SIG_CTRLBREAK);
	return(oldAction != SIGA_IGNORE);
#  endif
#endif
}
