#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__setscrn = "$Header: c:/curses/private/RCS/_setscrn.c%v 2.0 1992/11/15 03:24:37 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_set_scrn_mode()	- Set BIOS Video Mode

  PDCurses Description:
 	Sets the BIOS Video Mode Number ONLY if it is different from
 	the current video mode.  This routine is for DOS systems only.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_set_scrn_mode( int new_mode );

**man-end**********************************************************************/

#ifdef     OS2
int	PDC_set_scrn_mode(VIOMODEINFO new_mode)
#else
int	PDC_set_scrn_mode(int new_mode)
#endif
{
#ifdef	FLEXOS
	return( OK );
#endif
#ifdef	DOS
	int	cur;

	cur = (int) PDC_get_scrn_mode();
	if (cur != new_mode)
	{
		regs.h.ah = 0x00;
		regs.h.al = (char) new_mode;
		int86(0x10, &regs, &regs);
	}
	_cursvar.font = PDC_get_font();
	_cursvar.scrnmode = new_mode;
	LINES = PDC_get_rows();
	COLS = PDC_get_columns();
	return( OK );
#endif
#ifdef	OS2
        if (VioSetMode (&new_mode, 0) != 0)
        {
	  _cursvar.font = PDC_get_font();
	  _cursvar.scrnmode = new_mode;
	  LINES = PDC_get_rows();
	  COLS = PDC_get_columns();
	  return( OK );
        }
	else
	  return (ERR);
#endif
}
