TITLE  'Perspective projection (one-point)
NAME   PROJPERS
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Project 3D points to 2D via perspective projection(1pt)|
;   caller:      FAR call (QuickBASIC convention)                       |
;                call PROJPERS(vseg,voff)                               |
;    stack:     +06 = offset of 3D data pack                            |
;                08 = segment                                           |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 2
ARGpackoff      EQU [bp+06]
ARGpackseg      EQU [bp+08]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

PROJPERS_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:PROJPERS_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  PROJPERS
PROJPERS        PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGpackoff
                mov     si,[bx]
                mov     bx,ARGpackseg
                mov     es,[bx]
                mov     di,offset dgroup:xtype3
                mov     cx,21           ;packet is 21 words
                push    ds
                mov     ax,es
                mov     bx,ds           ;es:di->dgroup:xtype3
                mov     es,bx
                mov     ds,ax           ;ds:si->passed seg:off
                rep     movsw           ;copy xform pack to dgroup
                pop     ds

                mov     cx,points3
                or      cx,cx
                jnz     DoPers          ;got some points to work on
                jmp     PROJPERSxit

DoPers:         push    ds
                call    Trap0
                mov     di,offXYj3
                mov     es,segXYj3      ;es:di->one-pt projection points (x,y)
                mov     si,offXYp3
                mov     ds,segXYp3      ;ds:si->prime pts (x,y,z)
                ASSUME ds:nothing

                mov     ax,1000         ;invariant calc outside loop
                mov     bp,ax
                imul     ss:distV3       ;dx:ax=distV3*1000
                mov     ss:distV3ml,ax  ;or is distV3 always pos?
                mov     ss:distV3mh,dx

Pers1:          lodsw                   ;get Xprime
                mov     ss:OPx,ax
                lodsw                   ;get Yp
                mov     ss:OPy,ax
                lodsw                   ;get Zp
                add     ax,ss:distV3
                or      ax,ax
                jz      PersSkip        ;avoid div/0 (blatent 0 anyway)
                mov     ss:OPdiv,ax     ;calc perspective divisor

                mov     ax,ss:distV3ml
                mov     dx,ss:distV3mh  ;dx:ax=distV3*1000
                idiv     ss:OPdiv        ;ax=(distV3*1000)\div
                mov     bx,ax           ;use in Y calc too
                mov     ax,ss:OPx
                sub     ax,ss:OrgX3     ;ax=(xp-OrgX3)
                imul     bx         ;dx:ax=(xp-OrgX3)*((distV3*1000)\div)
                idiv     bp
                add     ax,ss:OrgX3;ax=OrgX3+(xp-OrgX3)*((distV3*1000)\div)\1000
                stosw              ;perspective X

                mov     ax,ss:OPy  ;bx=(distV3*1000)\div
                sub     ax,ss:OrgY3;ax=(yp-OrgY3)
                imul     bx         ;dx:ax=(yp-OrgY3)*((distV3*1000)\div)
                idiv     bp
                add     ax,ss:OrgY3;ax=OrgY3+(yp-OrgY3)*((distV3*1000)\div)\1000
                stosw              ;perspective Y

Pers2:          loop    Pers1
                jmp     short PersXit1

                ;if div/0 (blatent)
PersSkip:       mov     ax,ss:OPx
                stosw
                mov     ax,ss:OPy
                stosw
                loop    Pers1

PersXit1:       call    UnTrap0

PersXit2:       pop     ds
                ASSUME ds:dgroup
PROJPERSxit:    pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                pop     bp
                mov     sp,bp
                pop     bp
                RET     PARMS*2
PROJPERS        ENDP

Trap0           PROC NEAR

                push    ds
                sub     ax,ax
                mov     ds,ax
                mov     es,ax
                mov     si,ax           ;ds:si->div by zero int vector
                mov     di,ax           ;es:di->ditto
                cli
                lodsw                   ;get old offset
                mov     ss:[INT0off],ax
                lodsw                   ;get old segment
                mov     ss:[INT0seg],ax
                sti
                cli
                mov     ax,offset DIV0INT ;point it to DIVINT
                stosw
                mov     ax,cs
                stosw
                sti
                pop     ds
                ret

DIV0INT:        add     sp,6            ;remove IRET address,flags
                call    UnTrap0
                mov     ax,99
                jmp     PersXit2

Trap0           ENDP

UnTrap0         PROC NEAR

                sub     ax,ax
                mov     es,ax
                mov     di,ax           ;es:di->div by zero int vector
                mov     ax,INT0off
                cli
                stosw                   ;put old offset
                mov     ax,INT0seg
                stosw                   ;put old segment
                sti
                ret
UnTrap0         ENDP

PROJPERS_TEXT   ENDS
                END

