;   Program: password.sys
;   Author:  Christoph Christ
;   Purpose: Implements input of an Password in the config.sys File
;   Date:    1.11.92
;   Version: 1.01
;   USE:
;     Insert as the first Command in Config.sys the following line:
;
;       DEVICE=PASSWORD.SYS

TITLE Password

.8086

StrStart  EQU  1   ; MSDOS - kompatible Einleseroutine ohne Echo

PushAll Macro
  push ax
  push bx
  push cx
  push dx
  push si
  push di
  push bp
  push ds
  push es
EndM

PopAll Macro
  pop es
  pop ds
  pop bp
  pop di
  pop si
  pop dx
  pop cx
  pop bx
  pop ax
EndM


CODE Segment byte public
public Password
Assume cs: Code, ds: Code, SS:Code

ORG 0

; Device header ------------------------------------------------

Next_Driver    DD -1
Attributes     DW 0
StrategyProc   DW OFFSET Strategy
CommandsProc   DW OFFSET Commands
Device_Name    DB 'PASSWORD'

; Variables ----------------------------------------------------

Input          DB 40, 0, 40 dup(?)     ;
Password       DB 5, 'FWFWQ', 35 dup(?),'$'; "GUEST" is standard


Copyright      DB 'Password Protection V1.0 (c) by Christoph Christ 1.11.1992',13,10
               DB '----------------------------------------------------------',13,10,'$'
Prompt         DB 13,10, 'Please enter your password: $'
RepeatPrompt   DB 13,10, 'Code invalid - Repeat login',13,10,'$'
NoAccessMsg    DB 13,10, 'No Access - System stopped',13,10,10,10,'$'
AccessMsg      DB 13,10, 'Access - System can boot',13,10,10,10,'$'

Params         DD 0                    ; Adresse des Requestheaders
Counter        DB 3
Passed         DB 1                    ; 0=True 1=False
; Request header -----------------------------------------------

Request struc
   Len         db 0
   Unit        db 0
   CommandCode db 0
   Status      dw 0
   CountUnits  db 0
   EndAdress   dd 0
   BIOS_Param  dd 0
   DriveNr     db 0
   ConfigError dw 0
Request ends

; Strategy Entry Point ----------------------------------------


Strategy proc
         mov Word Ptr Params, bx       ; Request-Header is handled here
         mov Word Ptr Params + 2, es
Strategy endp

; Commands Entry Point ----------------------------------------

Commands proc
         cmp cs:passed, 0
         je Exit
Start:   PushAll                       ; Save all processor-registers 
         mov ax, cs                    ; Set Datasegment to Codesegment
         mov ds, ax
         call Encrypt
         mov dx, offset Copyright
         call PrintStr
Read:
         mov dx, offset Prompt
         call PrintStr
         call InputStr
         Call ScanLine
         jz OK
         cmp Counter, 0
         je NoAccess
         mov dx, offset RepeatPrompt
         call PrintStr
         dec counter
         jmp Read

OK:                                    ; Output Access Mesage and boot
         mov dx, offset AccessMsg
         call PrintStr
         mov passed, 0
         PopAll                        ; Get all previous saved Registers
Exit:    retf                          ; far return to DOS

NoAccess:
         mov dx, offset NoAccessMsg
         call PrintStr
         mov al, 09h                   ; Set Keyboardinterrupt to IRET
         mov ah, 25h                   ; mov dx, offset Int09
         int 21H
here:    jmp here                      ; won't terminate
         retf
Commands endp

Encrypt  proc
         mov di, 1                     ; start compare from Byte 1 (not 0!!)
         mov cl, byte ptr Password     ; Load length to encrypt the Password
         cbw                           ; cx := Length(Password)
         mov bx, offset Password       ; bx := ofs(Password) ds := Seg(P.W.)
L1:      mov al, cs:[bx + di]          ; al := Password[di]
         mov dx, di                    ; al := al xor di
         xor al, dl
         mov cs:[bx + di], al          ; Password[di] := sl
         inc di                        ; next character from String
         loopnz L1
         ret
encrypt  endp

printstr proc
         mov ah, 09H
         int 21H                       ; and output
         ret
printstr endp

InputStr proc
         mov ax, cs
         mov es, ax
         mov bx, offset Input
         call ReadString
         ret
InputStr endp

ScanLine proc
         mov cl, Byte ptr Password    ; Stringlength of Password
         xor ch, ch
         mov ax, cs
         mov es, ax
         mov ds, ax
         mov di, offset Password +1   ; load Strings to compare
         mov si, offset Input + 2
         cld
         repe cmpsb                   ; if ZF=0 then Input <> Password
         ret
ScanLine endp

ReadString proc
        xor di, di
        mov dl, byte ptr es:[bx + di] ; dl := Maximale Lnge
        xor dh, dh
        inc di
        mov byte ptr es:[bx + StrStart], 0  ; Stringlnge := 0
        inc di

@Repeat:
        call @GetChar                 ; einlesen
        cmp al, 32
        jae @Weiter                   ; erlaubt #32 .. #255
        cmp al, 13                    ; return ?
        je @quit
        cmp al, 8                     ; Backspace
        jne @Repeat
        call @Backspace
        jmp @repeat
@Weiter:
        cmp di, dx                    ; di > MaxStrLen
        je  @quit
        call @AddChar
        call @DisplayStern
        jmp @Repeat
@BackSpace:
        cmp di, 2                     ; wenn am puffer beginn nicht zurck
        jb @Repeat
        dec di
        mov ax, di                    ; Stringl. wegen lngenbyte noch verkrzen
        dec ax
        mov byte ptr es:[bx + StrStart], al  ; Lnge speichern
        mov al, 8                     ; Bildschirm-lschen
        call @OutChar
        mov al, 32
        call @OutChar
        mov al, 8
        call @OutChar
        ret
@AddChar:
        mov byte ptr es:[bx + di], al
        mov ax, di
        mov byte ptr es:[bx + StrStart], al
        inc di
        ret
@DisplayStern:
        mov al, '*'
        call @OutChar
        ret

@OutChar:
        push bx
        mov ah, 0Eh
        mov bx, 0007h
        int 10h
        pop bx
        ret
@GetChar:
        mov ah, 08h
        int 21h
@Quit:  ret
ReadString endp

Int09  proc
       iret
Int09  endp

CODE ends
end