program Func2Surf (input,output);
uses crt;
{ Program ported from Basic to TurboPascal by Stefan Kaufmann
  Adress: S. Kaufmann, UNM407 at DBNUAMA1.BITNET
          University of Bonn, West Germany

  The program does only the basic conversions like in the BASIC-Version.
  The first line of the raw 3D-DATA file must contain the GridSize,
  all other lines consist of x,y,z coordinates.

  Bonn, Nov. 1987, Stefan Kaufmann                                            }


VAR INFIL,OUTFIL       : TEXT {[7000]}; { SPEED IT UP!! }
    FNCF,FNIF          : STRING [64]; { PATH MAY BE GIVEN ... }
    xtics,ytics        : integer;
    GridNodes,Surfaces : integer;
    R1,R2              : real;
    Color              : integer;
    Script,Materials   : integer;
    Sides,Vertices     : integer;
    DataVersion        : integer;
    xc,yc,i,j          : integer;
    x,y,z              : real;
    C1,C2,N1,N2,N3,N4  : integer;
    LINE               : STRING [255];


begin
clrscr;
writeln ('Converting Raw 3D - DATA to SurfModl-Format');
writeln;
writeln ('ported from the Basic-version to TurboPascal by Stefan Kaufmann');
writeln;
writeln ('send any kind of note to:  S. Kaufmann, UNM407 at DBNUAMA1.BITNET');
writeln;
writeln;
if (paramcount <> 2) then
  begin
  write ('FileName InputFile : ');
  readln ( FNIF );
  write ('FileName Converted Data : ');
  readln (FNCF);
  end
else
  begin
  FNIF := paramstr(1);
  FNCF := paramstr(2);
  end;

writeln;
writeln ('Attaching Files ...');
assign (InFil,FNIF);
reset (InFil);
assign (OutFil,FNCF);
rewrite (OutFil);

writeln ('Setting default parameters ...');
DataVersion := 2;
Materials   := 1;
Script      := 0;
Vertices    := 4;
Sides       := 2;
R1          := 1.0;
R2          := 1.0;
Color       := 3;
C1          := 4;
C2          := 1;

write ('Reading GridSize ...');
readln  (InFil,xtics,ytics);
writeln (xtics:4,ytics:4);

writeln ('Calculating GridNodes and Surfaces ... ');
GridNodes   := (xtics * ytics);
Surfaces    := ((xtics - 1) * (ytics - 1));

writeln ('Writing Parameters ...');
writeln (OutFil,'SurfModl - Data - File  [',FNCF,']');
writeln (OutFil,DataVersion:6);
writeln (OutFil,Materials:6,GridNodes:6,Surfaces:6,Script:6,Vertices:6,Sides:6);
writeln (OutFil,R1:10:6,R2:10:6,Color:6);

writeln;
write ('Moving Data between ',FNIF,' and ',FNCF,' ... ');
xc := WhereX;
yc := WhereY;

for i:=1 to xtics do
  begin
  gotoxy(xc,yc);
  clreol;
  write(i);
  for j:=1 to ytics do
    begin
    readln (InFil,line);            { Moving Data line by line is quicker   }
    writeln (OutFil,line);          { than readln(x,y,z) and writeln(x,y,z) }
    end;
  end;

writeln;
writeln;
writeln ('Closing ',FNIF,' ...');
close (InFil);

write ('Calculating Surface connectivity ... ');
xc := WhereX;
yc := WhereY;
for i:=1 to (xtics-1) do
  begin
  gotoxy(xc,yc);
  clreol;
  write(i);
  for j:=1 to (ytics-1) do
    begin
    N1 := (I-1)*ytics + j;            { N1 .. N4 = NodeNo. for Vertices }
    N2 := (I-1)*ytics + j + 1;
    N3 := (I)  *ytics + j + 1;
    N4 := (I)  *ytics + j;
    writeln (OutFil,C1:6,C2:6,N1:6,N2:6,N3:6,N4:6);  { C1 = Number of Vertices}
    end;                                             { C2 = Materialconst. }
  end;

writeln;
writeln;
writeln ('Closing ',FNCF,' ...');
close (OutFil);
writeln ('done');
end.
