/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

static char S_RCSID[] = "$Header: e:/itrans/src/rcs/itotex.c 1.6 91/10/13 16:51:13 avinash Exp $";

#include "itrans.h"

/* =================================================================== */
/* define macro names to be used*/
/* name of \newbox to be created */
#define	BOX_NAME	"zErOdEpTh"
/* name of kern macro - \def\..#1{{\kern#1em}} */
#define KERN_NAME	"kRn"
/* name of subscript macro - see macro defn in itotex_start() */
#define SUBS_NAME	"sBs"

/* =================================================================== */
static void S_get_texchar(char tchr[], int pcode);
/* =================================================================== */
/****
int cus_to_tex(comp_unit_t* cus, chain of PostScript Chars to output
	      int fsize,
	      char texcomm[]) the tex commands returned here
*****/
int cus_to_tex(comp_unit_t* cus,
	      int fsize,
	      char texcomm[])
{
    int dx, dy, pcode;
    char tchr[16];

    while (cus) {
	dx = cus->deltax;
	dy = cus->deltay;
	pcode = cus->u_pschar;


#ifdef DEBUG
fprintf(stderr, "totex: constructing char: dx %d dy %d pcode %d\n", dx, dy, pcode);
#endif /* DEBUG */

	if (dx != 0) {
	    sprintf(texcomm, "\\%s{%.3f}", KERN_NAME, dx / 1000.0);
	    texcomm += strlen(texcomm);
	}


	if (dy != 0) {
	    if (pcode == NO_PSCHAR) {
		
	        fprintf(stderr,
	    "itotex.c:Error:cus contain an non-zero Ydelta for NO_PSCHAR\n"); 
	        /* can't give any more info here, anyway, this error should
	         * have been caught when reading in the IFM file....
	         * (see font.c::fillup_font())
	         */
	    } else {

	        S_get_texchar(tchr, pcode);
	        sprintf(texcomm, "\\%s{%.3f}{%s}", SUBS_NAME, dy/1000.0, tchr);
	        texcomm += strlen(texcomm);
			/* above macro creates a raised box, but assigns
			 * it a height and depth of 0, so that it does
			 * change the interline spacing.
			 * box name (zERoDeptH) could cause namespace
			 * collision with
			 * the users text, so use a strange mix...
			 */
		}
	} else { /* dy is zero... */
	    if (pcode != NO_PSCHAR) {
	        S_get_texchar(tchr, pcode);
	        sprintf(texcomm, "%s", tchr);
	        texcomm += strlen(texcomm);
	    }
	}
	
	cus = cus->next;
    } /* while cus */

    return TRUE;
}
/* =================================================================== */
static void S_get_texchar(char tchr[], int pcode)
{
    if (isalnum(pcode)) sprintf(tchr, "%c", pcode);
    else if (isprint(pcode)) sprintf(tchr, "{\\char`\\%c}", pcode);
    else sprintf(tchr, "{\\char%d}", pcode);
}
/* =================================================================== */
int outtex_start()
{
    printf("\\newbox\\%s\n", BOX_NAME); /* box used by cus_to_tex()*/
    printf("\\def\\%s#1{{\\kern#1em}}\n", KERN_NAME);
    printf("\\def\\%s#1#2{{\\setbox\\%s=\\hbox{\\raise#1em\\hbox{#2}}%%\n\\ht\\%s=0pt\\dp\\%s=0pt\\box\\%s}}\n",SUBS_NAME,BOX_NAME,BOX_NAME,BOX_NAME,BOX_NAME);
    return TRUE;
}
int outtex_end()
{
    return TRUE;
}
/* ============================^ itotex.c ^ =========================== */
