/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

static char S_RCSID[] = "$Header: e:/itrans/src/rcs/lang.c 1.3 91/10/13 16:50:51 avinash Exp $";

#include "itrans.h"

/* =================================================================== */
void init_langs(lang_t *l, int num)
{
    int i;
    for (i = 0; i < num; i ++) {

	null_lang(l + i);

	l[i].langno = i + ILANG_TOK;
	switch(i + ILANG_TOK) {
	case MARATHI_TOK:
	    l[i].name = "marathi";
	    break;
	case HINDI_TOK:
	    l[i].name = "hindi";
	    break;
	case ORIYA_TOK:
	    l[i].name = "oriya";
	    break;
	case KANNADA_TOK:
	    l[i].name = "kannda";
	    break;
	case SANSKRIT_TOK:
	    l[i].name = "sanskrit";
	    break;
	case TAMIL_TOK:
	    l[i].name = "tamil";
	    break;
	case BENGALI_TOK:
	    l[i].name = "bengali";
	    break;
	case TELUGU_TOK:
	    l[i].name = "telugu";
	    break;
	case MALAYALAM_TOK:
	    l[i].name = "malyalam";
	    break;
	case GUJARATI_TOK:
	    l[i].name = "gujarati";
	    break;

	case ILANG_TOK:
	default:
	    l[i].name = "default indian language";
	    break;
	}
    }
}
/* =================================================================== */
void null_lang(lang_t *l)
{
    l->curr_ifmname = NULL;
    l->curr_fontcmd = NULL;
    l->curr_font = NULL;
}
/* =================================================================== */
void clear_lang(lang_t *l)
{
    if (l->curr_ifmname) free(l->curr_ifmname);
    if (l->curr_fontcmd) free(l->curr_fontcmd);

    /* don't free font (it is kept in allfonts also), just make it NULL */

    null_lang(l);
}
/* =================================================================== */
/* cmd is of the form: "\XXXifm=YYY"
 * first of all, the ifm file is searched for, and if not found, is
 * loaded in.
 * Then, the language structure is filled in.
 */
int find_load_ifm(lang_t* l, allfonts_t allf, char ifmtok[])
{
    char name[NAMELEN];
    char *eqp;
    int s, fnum;
    font_t* ff;
    
    eqp = strchr(ifmtok, '=');
    if (eqp == NULL) {
        fprintf(stderr, "Illegal Indian IFM name line: %s\n", ifmtok);
        return FALSE;
    }

    eqp ++;
    sprintf(name, "%s", eqp); /* to eat up all white space around it..*/

    if (strlen(name) < 1) {
	if (G_verbose > 1) fprintf(stderr, "Null IFM statement (line %d) -- ignored\n",
		G_lineno);
	return FALSE;

    }

    if (chk_ext(name, ".ifm")) { /* missing .ifm, or wrong extension..*/
        strcat(name, ".ifm");
    }

    ff = find_font(allf, name);
    if (!ff) {

        if (G_verbose > 0) fprintf(stderr, "Loading IFM file %s\n", name);

        /* allocate space for a single font.. */

        ff = (font_t*) malloc (sizeof(*ff));
        init_font(ff);

        s = fillup_font(ff, name);

        if (!s) {
	     fprintf(stderr, "Error: fillup font error (fill up from %s)\n", name);
	     free(ff);
	     return FALSE;
        }

	/* stuff it in the array of IFM files.... */
	s = 0;
	while (allf[s]) s++; 
	if (s >= FONTS_MAX) {
	    fprintf(stderr, "Warning: cannot load in any more IFM files, will reuse previous location...\n");
	    fprintf(stderr, "(Max IFM files is %d, Current Line is %d, Loading %s)\n", 
				FONTS_MAX, G_lineno, name);
	    s--;
	    free(allf[s]);
	}
	allf[s] = ff;

#ifdef DEBUG
        fprintf(stderr, "successfully loaded ifm: %s at loc %d\n", name, s);
#endif /* DEBUG*/
    } else {
        if (G_verbose > 0) fprintf(stderr, "IFM  file %s already loaded.\n", name);
    }

    l->curr_font = ff;

    if (l->curr_ifmname) free(l->curr_ifmname);

    eqp = strrchr(name, DIRSEP);
    if (!eqp) eqp = name;
    else eqp++;
    l->curr_ifmname = (char*) malloc( sizeof(char) * (strlen(eqp) + 1));
    strcpy(l->curr_ifmname, eqp);

    return TRUE;
}
/* =================================================================== */
