#include <tiff.h>

extern LONG get_1st_ifd();
extern SHORT type_length();
extern BOOL access_ifd();
extern BOOL read_dir();

SHORT
rfield_size(fhandle, fdtype, buffer)
SHORT fhandle;
SHORT fdtype;
FIELD_INFO far *buffer;
{
	LONG ifd_offset = get_1st_ifd(fhandle);
	LONG new_offset;
	TIFF_DIR_ENTRY dirent;
	SHORT entry_count;
	SHORT subfile_type;
	SHORT n;
	LONG tot_size;

	/* go through IFD's ... stop at null IFD offset */
	while(ifd_offset)
	{
		/* get pertinent IFD data */
		if(access_ifd(fhandle, ifd_offset,
		  (TIFF_DIR_ENTRY far *)&dirent, &entry_count, &subfile_type,
		  &new_offset))
		{
			return(0);
		}

		/* match on subfile type? */
		if(fdtype == subfile_type)
		{
			n = entry_count - 1;
			tot_size = 0;

			/* go through each entry */
			while(n-- > 0 && !read_dir(fhandle,
			  (TIFF_DIR_ENTRY far *)&dirent))
			{
				LONG temp = (LONG)type_length(dirent.type);
				temp *= dirent.length;
				tot_size += temp;
				tot_size += SHORT_SIZE + SHORT_SIZE;
			}

			/* if we bombed out early, error exit */
			if(n > 0)
			{
				return(0);
			}

			/* since we matched, we can now go bye-bye */
			buffer->num_tags = entry_count;
			buffer->num_bytes = tot_size;
			return(1);
		}
		ifd_offset = new_offset;
	}
	return(0);
}
