	Title	SHOWTSRS - Program to scroll MAPMEM data
Comment ~			    31-May-1989 00:03:10
	Author:     Tom Gilbert's Heart&Mind
		    7127 Lafayette Avenue
		    Kansas City, KS 66109
		    (913) 299-2701

	Copyright   (c) 1988/9 by Heart & Mind
		    for NON-Commercial Use ONLY
		    Use and distribution in the
		    Public Domain is encouraged
v3.2 Toad hall Tweak
	~
	DOSSEG
	.MODEL  small
	.STACK  100h
	.DATA
headline	label	byte
	DB	" >ShowTSRs [anything for HELP]  -  Version 3.2  - "
	DB	" by Tom Gilbert's Heart&Mind",13,10," ",13,10

	DB	" PSP  MCB  files bytes   owner     command line   "
	DB	" chained/hooked INT vectors",13,10
	DB	" ---- ---- ----- ----- --------- ---------------- "
	DB	" --------------------------",13,10
helpdat label	byte
DB 13,10,"        "
DB "ShowTSRs displays a map of memory blocks and interrupts used"
DB 13,10,"        "
DB "     by TurboPower DISABLE and RELEASE or UnMark and ReMark."
DB 13,10,13,10,"	"
DB 'The "PSP" is the Segment of a program, environment or "trapped"'
DB 13,10,"                       memory block."
DB 13,10,13,10,"	"
DB 'The "MCB" (Memory Control Block) is located one paragraph before'
DB 13,10,"                   the block it controls."
DB 13,10,13,10,"	"
DB 'The "files" include the 5 standard DOS devices.'
DB 13,10,13,10,"	"
DB 'The "bytes" are block lengths in decimal.'
DB 13,10,13,10,"	"
DB 'The "owner" names other than "DOS", "TSR WATCHER", "LoadTSR" and'
DB 13,10,"        "
DB 'those for [F]Marks come from the environment.  The name "command"'
DB 13,10,"        "
DB 'appears when NO "owner" is found in the environment.'
DB 13,10,13,10,"	"
DB 'The "command line" is reproduced for the first 16 bytes.'
DB 13,10,"        "
DB "Those followed by an elipsis (...) exceed 16 bytes."
DB 13,10,13,10,"	"
DB 'The "vectors" which are "chained" from program to program will be'
DB 13,10,"        "
DB "displayed if WATCH is installed.  Otherwise, only those at the top"
DB 13,10,'        of the chain ("hooked") are displayed.'
DB 13,10,13,10,"	"
DB "EGA Info 8 bytes and Inter-application Communication"
DB 13,10,"        "
DB "Area 16 bytes are provided in HEX & ASCII dump format."
DB 13,10,13,10,"	"
DB "If expanded memory is installed, the Manager's Version number,"
DB 13,10,"        "
DB "Page Frame Segment (through which memory is windowed) and block"
DB 13,10,"        "
DB "information will be shown.  User names are shown if provided."
DB 13,10,13,10,"  "
DB "                     ***** End of ShowTSRs Help *****",13,10
HELPLEN equ $-helpdat
statline DB	" Line:    of	"
	DB	" Move:   PGUP PGDN HOME END or Use ESC key to"
	DB	" Exit: ShowTSRs "
cmdparam DB	" ",13
datf	DB	0		; Command flag 0 = Data else HELP
spsp	DW	?		; Segment of ProgramSegmentPrefix
fmem	DW	?		; Free System Conventional RAM
pbuffer	DW	0		; Position in buffer (offset)
sbuffer	DW	?		; Base of buffer (segment)
lbuffer	DW	?		; Length of buffer
linenum	DW	?		; Data buffer line
lastnum	DW	?		; Last buffer line
COLUMNS	EQU	80		; Number of columns used per row
rows	DW	24		; Number of last row for display
datrows	DW	20		; Number of data rows per page
lastrow	DW	24		; Number of last display row
cell	LABEL	WORD		; Cell (character and attribute)
char	DB	" "		; Initialize to space
attr	DB	?		; Attribute
mode	DB	?		; Initial mode
pag	DB	?		; Initial display page
newvid	DB	0		; Video change flag
cga	DB	1		; CGA flag - default yes
vidadr	DW	0B800h		; Video buffer address - default CGA
MONO	EQU	0B000h		; Monochrome address
statatr	DB	030h		; Color default - black on cyan
BWSTAT	EQU	070h		; B&W default - black on white
scrnatr	DB	017h		; Color default - white on blue
BWSCRN	EQU	007h		; B&W default - white on black

exkeys	DB 71,72,73,79,80,81; Extended key codes
LEXKEYS	EQU     $-exkeys	; Table of keys
extable	DW  HomeK,upk,pgupk,endk,downk,PgDnK,NoneK

egahdg	DB " EGA Information Area at 0040:00A8 "
EGALEN	EQU $-egahdg
icahdg	DB " Inter-application Communications Area:",13,10," 0040:00F0 "
ICALEN	EQU $-icahdg
emsname	DB "EMMXXXX0"		; EMM standard Name
tpages	DW 0			; Page accumulator
emserm	DB 13,10
	DB "   *** Expanded Memory NOT Installed or NOT Working ***"
EMERML	EQU $-emserm
emmshdg	DB " block    pages   KBytes   UserName  "
	DB "  (Expanded Memory - Version "
EMMLEN1	EQU $-emmshdg
	DB ")",13,10
dashes	DB " -----    -----   ------   --------   "
	DB " (LIM page frame address - "
EMMLEN2	EQU $-emmshdg-EMMLEN1
totlm	DB " total"
freem	DB "  free"
fmark	DB "FMark TSR"		; [F]Mark ID - Now using " TSR"

doscm	DB "DOS<command.com><CONFIG.SYS> <environment><trapped>"
disam	DB "***  D I S A B L E D  ***"
DISALEN	EQU $-disam
loadtsr	DB "Load"		; LoadTSR Command Identification
watchS	DB "TSR WATCHER"	; WATCH Command Line Parameter
watchF	DW  0			; MCB Index to WATCH PSP if Set
startl	DW  0			; Destination Index at Line Start
vpos	DW  ?			; WATCH Next PSP Position

MCB	STRUC
pspa	DW  0			; Program Segment Prefix or Mark Address
mcba	DW  0			; Memory Allocation Block Address
mcbl	DW  0			; Length in paragraphs to next MCB
mcbf	DW  0			; Flags 0=Trapped, FF=Env, FF00=PGM
MCB	ENDS			;   and Special Blocks are FFFF

mcbs	MCB   100 DUP (<>)	; Array of MCB Structures

	.CODE

Main	PROC
	mov	ax,@data	; Destination is data
	mov	ES,ax		; flag with length of
	mov	di,OFFSET datf	; command line
	mov	si,80h		; parameter
	movsb
	mov	ES:spsp,DS	; Preserve PSP Segment and
	mov	bx,DS:[2]	; Use Total System RAM to
	sub	bx,ES:spsp	; Calculate Free Memory
	mov	DS,ax		; Set DS Register to DATA
	mov	fmem,bx		; Store Free Memory

	cli			; Turn off interrupts
	mov	SS,ax		; Make SS and
	mov	sp,OFFSET STACK	;   SP relative to DGROUP
	sti			; Re-Enable interrupts

	mov	bx,sp		; Convert stack pointer to
	mov	cl,4		; number of stack paragraphs
	shr	bx,cl
	add	ax,bx		; Add SS to get end of program
	sub	ax,spsp		; Subtract start to get length
	mov	ES,spsp		; Modify Memory
	mov	bx,ax		; New Block Size
	mov	ah,4Ah		; through DGROUP
	int	21h
	mov	bx,0FFFFh
GetMore:
	mov	ah,48h		; Request all
	int	21h		; remaining
	jc	GetMore		; memory

	mov	ES,ax		; Set Es Register to Block
	mov	sbuffer,ax	; Save buffer segment and
	mov	lbuffer,bx	; actual length allocated
	xor	di,di		; Point to beginning and
;v1.1	mov	cx,lbuffer	; fill data buffer
	mov	cx,bx	;lbuffer	;fill data buffer		v1.1
	mov	al," "		; With Spaces
	rep	stosb
	xor	di,di
	test	datf,0FFh	; If command parameter
	jnz	HelpOpt		; then provide HELP
	 xor	dx,dx		; else zero index
	 call	GetData		; Get and Show
	 jmp	SHORT EndData	; scrollable data

HelpOpt:
	mov	cmdparam,"?"		; Show HELP requested
	mov	si,OFFSET helpdat	; and store help data
	mov	cx,HELPLEN		; for scrollable display
	rep	movsb
EndData:
	call	EndCount		; Count buffer
	mov	ax,linenum		; data lines and
	mov	lastnum,ax		; store the count
	mov	lbuffer,di		; and store length
	call	Video			; Adjust for mode & adapter
	mov	dx,2B00h		; Hide cursor off screen
	xor	bh,bh
	mov	ah,2
	int	10h
	call	HomeK			; Display 1st Page
	mov	ax,datrows		; If more data
	sub	ax,lastnum		; lines to show
	jc	NextKey			; then accept keys
	 sub	datrows,ax		; else modify last
	 sub	lastrow,ax		; row for ending
NextKey:
	mov	ah,7			; Get a key
	int	21h
	or	al,al			; If a null			v1.1
	je	Extended		; then Must be extended code
	cmp	al,27			; else If NOT ESCape
	jne	NextKey			; then Ignore unknown command

quit:	mov	ES,sbuffer		; Release buffer
	mov	ah,49h
	int	21h
	cmp	newvid,1		; If video not changed
	jne	thatsall		; then that's all
	mov	al,mode			; else Restore video mode,
	xor	ah,ah
	int	10h
	mov	al,pag			; page,
	mov	ah,5
	int	10h			; and cursor
thatsall:
	mov	cx,lastrow		; Load last row and
	mov	ax,rows			; Calculate rows to
	sub	ax,cx			; be scrolled blank
	xchg	cl,ch			; Set Upper Left and
	mov	dx,cx			; copy in order to
	add	dh,al			; adjust Lower Right
	mov	dl,COLUMNS-1		; corner of window
	mov	ah,6			; Call ROM BIOS to
	mov	bh,7			; clear the window
	int	10h
	mov	dx,cx			; Set cursor above
	dec	dh			; window so prompt
	xor	bh,bh			; is on last line
	mov	ah,2			; when Exit to DOS
	int	10h
	mov	ax,4C00h		; Zero Error Level
	int	21h			; For => DOS 2.00
					; RED SWITCH for 1

Extended:
	mov	ah,7			; Get extended code
	int	21h
	push	ES
	push	DS			; Load DS into ES
	pop	ES
	mov	di,OFFSET exkeys	; Load address and
	mov	cx,LEXKEYS+1		; length of key list
	repne   scasb			; Find position
	pop	ES
	sub	di,(OFFSET exkeys)+1	; Point to key and adjust
	shl	di,1			; pointer for word addresses
	call	extable[di]		; Call appropriate procedure
	jmp	NextKey

HomeK:
;v1.1	mov	pbuffer,0		; HOME - Zero the buffer
;v1.1	mov	ax,pbuffer		; position for 1st page
	xor	ax,ax			;HOME - zero the buffer		v1.1
	xchg	ax,pbuffer		;pbuffer cleared, AX=old val	v1.1
	jmp	SHORT GoPage

upk:	mov	ax,-1			; UP - GoBack one line if room
	jmp	SHORT GoPage

pgupk:	mov	ax,datrows		; PGUP - Page back
	neg	ax			; Up to page lines
	jmp	SHORT GoPage

endk:	mov	ax,lbuffer		; END - Get last byte of file
	mov	pbuffer,ax		; Make it the file position
	mov	ax,datrows		; Go Backward enough
	neg	ax			; lines for last page
	jmp	SHORT GoPage

downk:	mov	ax,1			; GoForward 1 line if room
	jmp	SHORT GoPage

PgDnK:	mov	ax,datrows		; PGDN - Go forward <= page
GoPage:	push	ax
	call	Pager
NoneK:	retn				; Ignore unknown key
Main		ENDP

Video		PROC
	push	ES			; Preserve Extra Segment
	mov	ah,12h			; Call EGA status function
	mov	bl,10h
	sub	cx,cx			; With Clear status bits
	int	10h
	sub	ax,ax			; If status is still Clear
	jcxz	modechk

	mov	ES,ax			; or if EGA is NOT active
	test	BYTE PTR ES:[487h],1000b
	jnz	modechk			; then check CGA or Mono Mode

	mov	ax,1130h		; else get EGA information
	int	10h
	mov	al,dl			; Make lines per screen
	cbw				; into a Word Value
	mov	rows,ax			; Reset number of the
	mov	lastrow,ax		; last row and number
	sub	ax,4			; of rows available for
	mov	datrows,ax		; data from their defaults
	dec	cga			; Clear the CGA Flag
modechk:
	pop	ES			; Restore Extra Segment
	mov	ah,0Fh			; Get video mode
	int	10h
	mov	mode,al			; Save initial
	mov	pag,bh			; mode and page
	mov	dl,al			; Work on copy
	cmp	dl,7			; If mono 7
	je	loadmono		; then Set mono
	 cmp	dl,15			; else if NOT mono 15
	 jne	graphchk		; then Check graphics
loadmono:
	mov	vidadr,MONO		; else Load mono address
	mov	statatr,BWSTAT		; Set B&W defaults for status
	mov	scrnatr,BWSCRN		; line and screen background
	dec	cga			; Set as NOT CGA
	cmp	al,15			; If NOT mono 15
	jne	VidExit			; then Done
	mov	dl,7			; else Set standard mono
	jmp	SHORT chmode

graphchk:
	cmp	dl,7			; If 7 or higher
	jg	color			; then color or done
	cmp	dl,4			; else 5 and 6 are
	jg	bnw			; usually black and white
	je	color			; 4 is color
	test	dl,1			; AND
	jz	bnw			; 0 and 2 are black and white
color:	cmp	dl,3			; If mode 3
	je	VidExit			; then Done
	 mov	dl,3			; else use color text mode
	 jmp	SHORT chmode

bnw:	mov	statatr,BWSTAT		; Set B&W defaults for status
	mov	scrnatr,BWSCRN		; line and screen background
	cmp	dl,2			; If mode 2
	je	VidExit			; then Done
	 mov	dl,2			; else use B&W text mode
chmode:	mov	al,dl			; Set video mode
	xor	ah,ah
	int	10h
	mov	ax,0500h		; Set video page 0
	int	10h
	mov	newvid,1		; Set flag
VidExit:
	ret
Video		ENDP

; Procedure EndCount - Go backward to count lines in file
; Input	ES:DI has buffer position
; Output	Modifies "linenum"

EndCount	PROC
	push	di
	std				; Go backwards to
	mov	al,13			; Search for CR
	mov	linenum,0		; Initialize line count
findstrt:
	mov	cx,0FFh			; Load maximum character count
	cmp	cx,di			; If NOT Near start of buffer
	jl	notnear2		; then use maximum count
	 mov	cx,di			; else search
	 jcxz	found			; only to start

notnear2:
	repne   scasb			; If previous CR NOT found
	jcxz	found			; then must be at start
	 inc	linenum			; else adjust line count
	 jmp	SHORT findstrt		;  and continue search

found:	pop	di			; Restore index
	cld				; and direction
	ret
EndCount	ENDP

; Procedure Pager - Displays status and text lines
; Input	Stack variable: lines to scroll (negative up, positive down)
; Output	Displays status plus "datrows" number of data lines

Pager		PROC
	push	bp
	mov	bp,sp
	mov	di,pbuffer		; Index to buffer position
	mov	cx,[bp+4]		; Get count argument for
	mov	ax,10			; linefeeds to count and
	or	cx,cx			; If No lines to count
	jz	show			; then show the page
	jg	forward			; else Count Forward
	 call	GoBack			; or Backward if neg
	 jmp	SHORT show		; before showing page

forward:
	call	GoForwd
show:	call	EndCount		; Count to first
	mov	ax,linenum		; line number to show
	add	ax,datrows		; Adjust to bottom line
	cmp	ax,lastnum		; If NOT past last
	jle	lineok			; then number is ok
	 mov	ax,lastnum		; else make it last

lineok:	push	DS			; Set Status Line DATA as
	pop	ES			; Destination for Values
	mov	di,OFFSET statline[9]
	xor	dx,dx			; Make 32-bit
	call	BinToDStr		; Line Number
	mov	ax,lastnum		;  and Last
	add	di,6			; Line Number
	call	BinToDStr		; Restore
	mov	ES,sbuffer		; ES to sbuffer

	mov	bl,statatr		; Set attribute for
	mov	BYTE PTR cell[1],bl	; status & headings
	xor	bx,bx			; Initialize counter
	mov	si,OFFSET headline	; for heading lines
hdloop:	push	bx			; Preserve counter
	push	DS			; Arg 1 - Segment
	push	si			; Arg 2 - Offset
	push	bx			; Arg 3 - Display Line
	push	cell			; Arg 4 - Char/Attrib
	call	CellWrt			; Write one line
	push	SS			; Restore DGroup
	pop	DS			; into DS register
	pop	bx			; Restore line count and
	mov	si,ax			; get returned position
	inc	bx			; Count the heading line
	cmp	bx,4			; If NOT yet 4 lines
	jc	hdloop			; then loop until 4

	mov	al,scrnatr		; Change attribute for
	mov	BYTE PTR cell[1],al	; data buffer display
	mov	si,pbuffer		; Index to pbuffer
datloop:
	push	bx			; Preserve counter
	push	sbuffer			; Arg 1 - Segment
	push	si			; Arg 2 - Offset
	push	bx			; Arg 3 - Display Line
	push	cell			; Arg 4 - Char/Attrib
	call	CellWrt			; Write line
	push	SS			; Restore DGroup
	pop	DS			; into DS register
	pop	bx			; Restore counter and
	inc	bx			; Count row displayed
	cmp	ax,lbuffer		; If position => end
	jnc	pagedone		; then page is done
	 mov	si,ax			; else update pointer
	 cmp	bx,rows			; If short of last row
	 jc	datloop			; then loop Until done

pagedone:
	mov	al,statatr		; Load attribute for
	mov	BYTE PTR cell[1],al	; writing status line
	mov	si,OFFSET statline
	push	DS			; Arg 1 - Segment
	push	si			; Arg 2 - Offset
	push	bx			; Arg 3 - Display Line
	push	cell			; Arg 4 - Char/Attrib
	call	CellWrt			; Write status line
	mov	ES,sbuffer		; Restore ES to buffer
	pop	bp			; Discard stack
	ret	2			; count argument
Pager		ENDP

; Procedure Retrace
; Purpose   Writes cell during horizontal retrace (CGA)
; Input	ES:DI has screen buffer position, AX has cell
; Output	Character to screen buffer

Retrace	PROC
	push	bx
	mov	bx,ax			; Save character

lscan2:	in	al,dx			; Look in the port
	shr	al,1			;   until it goes low
	jc	lscan2

	cli
hscan2:	in	al,dx			; Look in the port
	shr	al,1			;   until it goes high
	jnc	hscan2

	mov	ax,bx			; Restore and write it
	stosw
	sti
	pop	bx
	ret
Retrace	ENDP

; Procedure CellWrt - Writes a line to screen buffer
; Input	Stack variables (segment,offset,line,cell)
; Output	Line to screen buffer

CellWrt	PROC
	push	bp
	mov	bp,sp
	sub	dx,dx			; Clear as flag for scan
	cmp	cga,1			; If NOT CGA
	jne	noscan			; then leave zero
	 mov	dx,03DAh		; else load port #
noscan:	mov	ES,vidadr		; Load screen buffer segment
	mov	DS,[bp+10]		; Buffer segment
	mov	si,[bp+8]		; Buffer position
	mov	cx,80			; Cells per row
	mov	ax,[bp+6]		; Starting row
	mov	bx,80*2			; Bytes per row
	mul	bl			; Figure columns per row
	mov	di,ax			; Load as destination
	mov	ax,[bp+4]		; Set Attribute
movechar:
	lodsb				; Get character
	cmp	al,13			; If End of Data Line
	je	fillspc			; then end display line
	or	dx,dx			; else if NOT CGA
	je	notCGA			; then Write without delay
	call	Retrace			; else Write during retrace
	loop	movechar		; until End of Data Line
	jmp	SHORT nextline		; or end of display line

notCGA:	stosw
	loop	movechar		; If end of display line
	jmp	SHORT nextline		; then find End of Data Line

fillspc:
	mov	al," "			; Fill with space
	or	dx,dx			; If NOT CGA
	je	space2			; then direct
space1:	call	Retrace			; else Write during retrace
	loop	space1			; until end of display line
	inc	si			; Adjust for Data line LF
	jmp	SHORT exit		; Done

space2:	rep	stosw			; Write
	inc	si			; Adjust for LF
	jmp	SHORT exit		; Done

nextline:
	mov	ah,10			; Search for Data line feed

chklf:	lodsb				; Load and compare
	cmp	al,ah			; If NOT Data Line LF
	loopne  chklf			; then contine until
exit:	mov	ax,si			; Return position
	pop	bp
	ret	8
CellWrt	ENDP

GoForwd	PROC	; Search Forward through buffer
; Input	CX has number of lines; ES:DI has buffer position
; Output	Updates "pbuffer" and DI index

	cld				; Go forward
findf:	mov	pbuffer,cx		; Preserve count
	mov	cx,0FFh			; Load maximum character count
	repne   scasb			; If next LF NOT found
	jcxz	atend			; then must be at end
	mov	cx,pbuffer		; else If past end
	cmp	di,lbuffer		; then make at end
	jae	atend			; else loop until
	loop	findf			; at end or found
	mov	pbuffer,di
	call	EndCount		; Get line number
	mov	cx,lastnum		; If last number
	sub	cx,datrows		; minus display
	cmp	cx,linenum		; is => linenum
	jnc	GoForX			; then pbuffer Ok

atend:	mov	di,lbuffer		; Set index to end
	mov	cx,datrows		; Set page lines to
	neg	cx			; back-up during
	mov	al,10			; GoBack procedure
	call	GoBack
GoForX:	ret				; Return pbuffer
GoForwd	ENDP

GoBack	PROC	; Search Backward through buffer
	std				; Go backward
	neg	cx			; Make count positive
	inc	cx			; Use one extra going up
findb:	push	cx			; Preserve counter
	mov	cx,0FFh			; Load maximum character count
	cmp	cx,di			; If NOT near start of buffer
	jc	scanb			; then use maximum count
	 mov	cx,di			; else search only to start

scanb:	repne   scasb			; If previous LF NOT found
	jcxz	atstart			; then must be at start
	pop	cx			; else loop until start/done
	loop	findb
	add	di,2			; Adjust for cr/lf
	jmp	SHORT GoBackX		; Return position
atstart:
	pop	cx
	sub	di,di			; Set index and
GoBackX:
	mov	pbuffer,di		; pointer and
	ret				; Return position
GoBack	ENDP

BinToDStr   PROC
	Comment ~	Right Justified Decimal ASCII String
			Call With:  DX:AX = 32-bit value
					DS:DI after destination
			Returns:	Registers UnChanged
			~
	push	ax			; Preserve
	push	bx			; All the
	push	cx			; Registers
	push	dx			; Used by
	push	di			; procedure
	mov	cx,10			; Set Divisor
DivLoop:
	call	Divide			; Divide and
	add	bl,"0"			; Store ASCII
	dec	di			; Decimal Digit
	mov	ES:[di],bl		; Right to Left
	mov	bx,ax			; If 32-bits
	or	bx,dx			; NOT yet 0
	jnz	DivLoop			; Then Continue
	pop	di			; Else Restore
	pop	dx			; Registers to
	pop	cx			; Values on
	pop	bx			; Entry to
	pop	ax			; BinToDStr
	ret
BinToDStr   ENDP

Divide	PROC
	push	ax			; Preserve LSW
	mov	ax,dx			; Divide MSW as
	xor	dx,dx			; 32-bit Value
	div	cx			; Quotient
	mov	bx,ax			; in DX:BX
	pop	ax			; Divide LSW and
	div	cx			; Return DX:AX
	xchg	bx,dx			; Quotient and
	ret				; BX Remainder
Divide	ENDP

Val2ASCh	PROC
	mov	ah,al			; Preserve byte value
	and	al,0F0h			; Isolate high
	shr	al,1			; nibble
	shr	al,1			; into
	shr	al,1			; low
	shr	al,1			; nibble
	call	Val2Dig			; Convert and Store
	mov	al,ah			; Restore byte value
	and	al,0Fh			; Isolate low nibble
Val2Dig:
	add	al,30h			; Convert to display
	cmp	al,3Ah			; If decimal digit
	jc	V2DI			; then ASCII numeral
	 add	al,7			; else make HEX alpha
V2DI:	stosb				; Store ASCII HEX
	ret
Val2ASCh	ENDP

ShoWord	PROC
	push	ax			; Preserve LSB
	mov	al,ah			; Isolate MSB
	call	Val2ASCh		; Store Digits 1 & 2
	pop	ax			; Restore LSB and
	push	ax			; save the Word
	call	Val2ASCh		; Store Digits 3 & 4
	inc	di			; plus a space
	pop	ax			; Return Word
	ret
ShoWord	ENDP

SortMCBs	PROC
	mov	cx,bp			; Restore Count of
	dec	cx			; Blocks Minus 1
	xor	bx,bx			; Zero Index and
	xor	dx,dx			; Flag NO Swaps
SortLoop:
	add	bx,8			; Advance MCB Index
	mov	ax,mcbs[bx].mcbf	; Store
	mov	mcbs.mcbf,ax		; Flags
	mov	ax,mcbs[bx].mcbl	; length
	mov	mcbs.mcbl,ax		; MCB
	mov	ax,mcbs[bx].mcba	; and
	mov	mcbs.mcba,ax		; PSP
	mov	ax,mcbs[bx].pspa	; Addresses in
	mov	mcbs.pspa,ax		; base array member
	cmp	ax,mcbs[bx+8].pspa	; If PSPs Ascending
	jle	LoopSort		; then loop until done
	dec	dx			; else set sort flag
	mov	ax,mcbs[bx+8].pspa	;  and
	mov	mcbs[bx].pspa,ax	; swap
	mov	ax,mcbs[bx+8].mcba	; the
	mov	mcbs[bx].mcba,ax	; data
	mov	ax,mcbs[bx+8].mcbl	; for
	mov	mcbs[bx].mcbl,ax	; the
	mov	ax,mcbs[bx+8].mcbf	; two
	mov	mcbs[bx].mcbf,ax	; data
	mov	ax,mcbs.mcbf		; word
	mov	mcbs[bx+8].mcbf,ax	; table
	mov	ax,mcbs.mcbl		; array
	mov	mcbs[bx+8].mcbl,ax	; block
	mov	ax,mcbs.mcba		; members
	mov	mcbs[bx+8].mcba,ax	; until
	mov	ax,mcbs.pspa		; all
	mov	mcbs[bx+8].pspa,ax	; compared
LoopSort:
	loop	SortLoop
	or	dx,dx			; If Swaps
	jnz	SortMCBs		; Then Sort Again
	ret				; Until NO Swaps
SortMCBs	ENDP

Chk4TSR	PROC
	push	ax			; Preserve
	push	cx			; Registers
	push	di			; Index and
	push	ES			; Extra Segment
	mov	di,ES			; Advance to
	inc	di			; Controlled Block
	mov	ES,di			; Segment and Area
	mov	di,60h			; for TSR Signature
	mov	si,OFFSET watchS	; "TSR WATCHER"
	lodsb				; If NO "T"
	mov	cx,11			; in 11 bytes
	repne   scasb			; Then Check
	jne	C4Watch			;  for Watch
	cmpsw				; Else If next 2
	je	C4Texit			; Then Exit Equal
C4Watch:
	mov	si,OFFSET watchS	; "TSR WATCHER"
	mov	di,81h			; COMMAND LINE
	mov	cx,11			; PARAMETER
	rep	cmpsb			; RETURNS E or NE
C4Texit:
	pop	ES			; Restore Segment
	pop	di			; Index and
	pop	cx			; General
	pop	ax			; Registers
	ret
Chk4TSR	ENDP

IsEnviron   PROC
	mov	cx,mcbs[bx].mcba	; Convert Environment
	inc	cx			; MCBA to Environment
	mov	ES,cx			; Segment and
	mov	ax,mcbs[bx].mcbl	; Convert Length in
	mov	cl,4			; Paragraphs to
	shl	ax,cl			; Length in
	mov	cx,ax			; Bytes
	xor	di,di			; Scan for
	xor	ax,ax			; Double Null
SearchL:
	repne   scasb			; If First NOT
	dec	cx			; Followed by 2nd
	scasb				; Then Search
	jcxz	NoFname			; Until Environment End
	jne	SearchL			; OR Until Double Null
	mov	al,"."			; Scan for ".EXT"
	repne   scasb			; If NO Extent DOT
	jcxz	NoFname			; Then NO File Name
	mov	cx,10			; Else Look-Back for
	mov	ax,":\"			; Path Delimiter
FnameLp:
	dec	di			; Until
	cmp	ES:[di-1],al		; Either
	je	NameEnd			; Find OR
	cmp	ES:[di-1],ah		; Fail to
	je	NameEnd			; Find Start of
	loop	FnameLp			; File Name

NoFname:
	push	DS			; Put Data Segment into
	pop	ES			; Extra Segment Register
	mov	di,OFFSET doscm+4	; Point into
	mov	cx,3			; "DOS<command..."

NameEnd:
	mov	si,di			; Set Source to Name
	push	DS			; Preserve Data Segment
	push	ES			; Transfer ES after
	mov	ES,sbuffer		; Restoring Buffer Segment
	pop	DS			; into DS Register and
	mov	di,bp			; Restore MapData Pointer
	mov	dx,10			; Calculate
	sub	dx,cx			; filename
	xchg	dx,cx			; length and
	rep	movsb			; store Owner and
	add	di,dx			; space to command line
	pop	DS			; Restore Data Segment
	mov	si,OFFSET doscm+29	; Point to "<environment>"
	mov	cx,13			; Store its length
	rep	movsb			; into command line and
	add	di,6			; advance to vectors
	ret
IsEnviron   ENDP

IsProgram   PROC
	push	ax			; Preserve PSP and
	push	bx			; mcbs Index Pointer
	sub	bx,8			; Backup to Environment MCB
	call	IsEnviron		; Get Owner Information
	mov	cx,19			; Backup to
	sub	di,cx			; Command and
	mov	al," "			; Space-It-Out
	rep	stosb
	sub	di,20			; Restore Data
	pop	bx			; Pointer, mcbs
	pop	ax			; Index and PSP
	ret
IsProgram   ENDP

OwnComVec   PROC
	push	cx			; Preserve StoLoop Counter
	inc	di			; Advance to Owner
	mov	bp,di			; Preserve Pointer
	mov	ax,mcbs[bx].mcbf	; If Flags Show
	or	ax,ax			; is Trapped
	jz	DOSblock		; Then is DOS
	 mov	cx,mcbs[16].pspa	; Else If DOS
	 cmp	cx,mcbs[bx].pspa	; Is Below PSP
	 jc	Ck4Spec			; Then check if Special
DOSblock:
	mov	si,OFFSET doscm		; Else IS DOS
;v1.1	mov	cx,3			; copy
;v1.1	rep	movsb			; "DOS" and
	movsw				;copy 'DOS'			v1.1
	movsb				;				v1.1
	add	di,7			; space to command
	or	ax,ax			; If NOT Trapped
	jnz	Which?			; Then Check Which DOS
	 add	si,39			; Else Advance to
	 mov	cx,9			; "<trapped>"
	 jmp	SHORT MoveCmd

Which?:	mov	cx,13			; If Second MCB
	cmp	bx,16			; Then "<command.com>"
	je	MoveCmd			; Else If First MCB
	mov	si,OFFSET doscm+16	; Then "<CONFIG.SYS> "
	jc	MoveCmd			; Else Must Be
	 add	si,cx			; "<environment>"

MoveCmd:
	rep	movsb			; Move Command and
	jmp	OCVExit			; End the Line

Ck4Spec:
	cmp	ax,-1			; If NOT Special
	jne	CkEnvir			; Then Check If Environment
	mov	ax,mcbs[bx].pspa	; Else Load PSP
	mov	ES,mcbs[bx].mcba	; Point to MCB
	call	Chk4TSR			; If TSR WATCHER
	cmp	si,OFFSET watchS+11	; NOT Matched
	jne	Ck4Mark			; Then NOT Watch
	mov	ES,sbuffer		; Else Restore
	mov	cx,11			; Buffer and Copy
	mov	si,OFFSET watchS	; "TSR WATCHER"
	rep	movsb			; as Owner Name
	push	DS			; Set-Up for
	mov	ax,17			; Vectors
	jmp	Go2Vecs

CkEnvir:
	cmp	ax,0FFh			; If NOT Environment
	jne	Program			; Then Must be Program
	call	IsEnviron		; Else IS Environment
	jmp	OCVExit

Program:
	mov	ax,mcbs[bx].pspa	; Load the
	call	IsProgram		; Program PSP
	push	DS			; Preserve Data Segment
	mov	DS,ax			; Set to PSP and
	jmp	SHORT CmdParm		; Get Command Line

Ck4Mark:
	push	DS			; Preserve Data Segment
	mov	ES,ax			; Point into PSP at
	mov	di,65h			; [F]Mark signature
	mov	si,OFFSET fmark+5	; If "[F]M?.? TSR"
	mov	cx,4			; signature last
	rep	cmpsb			; 4 bytes match
	jcxz	IsFMark			; then is [F]Mark
	dec	di			; else check for loadtsr
	rep	cmpsb			; MenuTSR Identification
	pop	DS			; Restore Data and
	mov	ES,sbuffer		; MapData Buffer Segments
	mov	di,bp			; Restore MapData Pointer
	mov	si,OFFSET doscm+4	; Point to "command"
	mov	cx,7			; bytes and copy
	jne	CyOwner			; unless loadtsr
	 mov	si,OFFSET loadtsr	; is the real
CyOwner:
	rep	movsb			; Owner Area of MapData
	je	OCVExit
;v1.1	 add	di,2			; Advance to Command Line
	 inc	di			;advance to command line	v1.1
	 inc	di			;v1.1
	 push	DS			; Preserve Data Segment
	 mov	DS,ax			; Set to PSP and
	 jmp	SHORT CmdParm		; Get Command Line

IsFMark:
	push	ES			; Put PSP Segment AFTER
	mov	ES,sbuffer		; Restore MapData Buffer
	pop	DS			; into DS Register
	mov	si,di			; Set Source Index to
	mov	cx,9			; beginning of the
	sub	si,cx			; [F]Mark signature
	mov	di,bp			; Segment and Pointer
	rep	movsb			; Copy FMark Signature
CmdParm:
	inc	di			; Presume NO White Space
	mov	si,81h			; Get Command Length and
	mov	cx,[si-1]		; 1st Command Line Byte
	cmp	ch,"!"			; Check for White Space OR
	mov	ch,0			; If NO Parameter Length
	jcxz	Go2Vecs			; Then Adjust to Vectors

	jnc	NoSpace			; Else Ready with No Space
	 dec	di			; Else Make Room for Space
NoSpace:
	cmp	cx,19			; If Don't Need elipsis
	jle	CopyCmd			; Then copy all bytes
	 mov	cx,16			; else copy 16 bytes
	 mov	ax,".."			; adding continuation
CopyCmd:
	cmp	byte ptr DS:[si]," "
	jc	NotCopy			; If Printable
	 movsb				; Then Copy
	 jmp	Short CpyLoop		;  and Loop

NotCopy:
	inc	si			; Else Replace
	inc	di			; With Space
CpyLoop:
	loop	CopyCmd			;  and Loop
	cmp	ax,".."			; If NOT continuation
	jne	Go2Vecs			; Then Vectors
	 stosw				; Else continue
	 stosb				; elipsis (...)
Go2Vecs:
	pop	DS			; Restore Data Segment
	mov	ax,mcbs[bx].mcba	; If Memory Control Block
	inc	ax			; Segment Address + 1
	cmp	ax,mcbs[bx].pspa	; is NOT EQUAL to PSP
	jne	OCVExit			; then NO Interrupts
	 call	Vectors			; else store vectors
OCVExit:
	mov	ax,0A0Dh		; End the Data
	stosw				; Storage Line
	pop	cx			; Restore StoLoop Counter
	ret
OwnComVec   ENDP

GetData	PROC
	mov	ah,52h			; Use reserved DOS
	int	21h			; Interrupt to get
	mov	bp,ES:[bx-2]		; Start MCB Address
	xchg	bx,dx			; Zero Array Index
MCBLoop:
	add	bx,8			; Advance Index
	mov	ES,bp			; Locate MCB and
	inc	bp			; Block Segments
	mov	ax,ES:[1]		; Get PSP and
	mov	cx,ES:[3]		; Block Length
	cmp	ax,bx			; If CONGIG PSP
	je	FixPSP			; Then Fix to MCB+1
	or	ax,ax			; Else If NOT Trapped
	jnz	CkBlock			; Then Flag NOT 0
	 xor	dx,dx			; Else Zero mcbs Flag
FixPSP:	 mov	ax,bp			; Set Block = MCB+1
	 jmp	SHORT PutTable

CkBlock:
	cmp	ax,bp			; If PSP NOT MCB+1
	mov	dx,0FFh			; Then Flag Environment
	jnz	PutTable		;  for MCB Table Item
	xchg	dh,dl			; Else Flag as Program
	call	Chk4TSR			; If NOT [F]Mark, Watch, etc
	jne	PutTable		; Then Flag as "Program"
	 mov	dl,dh			; Else Flag as "Special"
PutTable:
	mov	mcbs[bx].mcba,ES	; Store MCB Address
	mov	mcbs[bx].pspa,ax	; Store PSP Address
	mov	mcbs[bx].mcbl,cx	; Length of Block and
	mov	mcbs[bx].mcbf,dx	; Flag Word of Type Block
	cmp	BYTE PTR ES:[0],"Z"	; If Last MCB
	je	LastMCB			; Then MCBs done
	 add	bp,cx			; Else Next MCB
	 jmp	short MCBLoop		; Until Last

LastMCB:
	mov	ES,sbuffer		; Set Buffer Segment
	mov	cx,3			; Calculate and
	shr	bx,cl			; Store Block
	mov	bp,bx			; Count
	call	SortMCBs		; Sort Blocks by PSP
	mov	cx,bp			; ReStore Counter and
	xor	bx,bx			; Index to Beginning
StoLoop:
	add	bx,8			; Advance MCB Index
	mov	ax,mcbs[bx].pspa	; Get PSP Address Word
	mov	startl,di		; UpDate Start of Line
	inc	di			; Start with a space
	call	ShoWord			; Display PSP in HEX
	mov	ax,mcbs[bx].mcba	; Get MCB Address Word
	call	ShoWord			; Display 4 HEX Digits
	mov	ax,mcbs[bx].pspa	; Restore PSP
	cmp	spsp,ax			; If ShowTSRs
	je	WasLast			; Then End Table
	mov	dx,mcbs[bx].mcbf	; If Flag Shows
	cmp	dh,0FFh			; NOT TSR Program
	jne	FilExit			; then skip files

	mov	ES,ax			; Point to Segment and
	mov	di,18h			; Offset of DOS Files
	mov	cx,20			; Initialize Counter
	mov	al,0FFh			; Looking for closed
	repne   scasb			; Preserve position
	mov	ax,di			; after search
	mov	ES,sbuffer		; Restore Data Buffer
	sub	ax,19h			; Calculate open files
	xor	dx,dx			; as a double word to
	mov	di,startl		; place under "l" in
	add	di,14			; "file" heading
	call	BinToDStr
FilExit:
	mov	ax,mcbs[bx].mcbl	; Store length as
	jmp	SHORT P2Bytes		; decimal bytes

WasLast:
	mov	ax,fmem			; Store free
	mov	si,offset freem+2	; "free" RAM
	mov	cx,4			; message
	rep	movsb			; Counter = 0 to END

P2Bytes:
	push	cx			; Preserve Counter
	xor	dx,dx			; Clear top and
	mov	cx,10h			; multiply into
	mul	cx			; double word
	mov	di,startl		; value for
	add	di,22			; "bytes"
	call	BinToDStr
	pop	cx			; If Counter is Zero
	jcxz	EndMCBs			; then MCBs are done
	 call	OwnComVec		; else finish line
	 jmp	StoLoop			; Until Last Line

EndMCBs:
	mov	ax,0A0Dh		; End the
	stosw				; Last Line
	call	InfoMap			; Add EGA & ICA Info
	mov	si,OFFSET emsname	; and If Driver Found
	call	EmmsMap			; add EMS Information
	ret
GetData	ENDP

DoIMdata	PROC
	push	DS			; Preserve Data Segment
	push	ax			; and Pointer to DOS Data
	mov	si,ax			; Initialize Source Index
	mov	cx,8			; Pointer and Counter
	mov	ax,40h			; Set DOS data segment in
	mov	DS,ax			; Data Segment Register
	cmp	si,0A8h			; If EGA Info Area
	jz	IMAOk			; then bytes IS 8
	 add	cx,8			; else bytes is 16
IMAOk:	push	cx			; Preserve byte counter

IMdigL:	inc	di			; Space before
	lodsb				; and Store 2
	call	Val2ASCh		; HEX ASCII digits
	loop	IMdigL			; until count complete
	pop	cx			; Restore byte counter
	pop	si			; and DOS data pointer
;v1.1	add	di,2			; Add 2 spaces
	inc	di			;add 2 spaces			v1.1
	inc	di			;v1.1
	cmp	si,0A8h			; If NOT 8 byte EGA
	jnz	IMascL			; then ready for ASCII
	 add	di,8			; else need 8 spaces
IMascL:	lodsb				; Get a byte
	cmp	al,20h			; If => space
	jnc	CkHigh			; then check delete
UseDot:	 mov	al,"."			; else use a dot

CkHigh:	cmp	al,7Fh			; If => space
	jnc	UseDot			; then use a dot
	stosb				; Send to MapData
	loop	IMascL			; until CX 'em

	pop	DS			; Restore Data Segment
	mov	ax,0A0Dh		; End the line
	stosw
	ret
DoIMdata	ENDP

InfoMap	PROC
	call	Underline		; Underline block data
	mov	si,OFFSET egahdg	; Transfer EGA Info
	mov	cx,EGALEN		; Area Heading
	rep	movsb
	mov	ax,0A8h			; Point to and
	call	DoIMdata		; transfer EGA data
	mov	si,OFFSET icahdg	; Transfer Inter-
	mov	cx,ICALEN		; Application Area
	rep	movsb			; Heading bytes
	mov	ax,0F0h			; Point to and
	call	DoIMdata		; get ICA data
Underline:
	mov	ax,"- "
	stosb				; Space plus
	mov	al,ah			; Minus sign
	mov	cx,76			; Underlines
	rep	stosb
	mov	ax,0A0Dh		; End the
	stosw				; underline
	ret
InfoMap	ENDP

EmmsMap	PROC
	mov	ax,3567h		; Get Vector for
	int	21h			; Function 67hex
	push	di			; Preserve store pointer
	mov	di,000Ah		; If Device
	mov	cx,8			; Name is NOT
	rep	cmpsb			; "EMMXXXX0"
	mov	ES,sbuffer		; after restore
	pop	di			; storage ES:DI
	jne	EmsErrX			; then Error Exit
	mov	ah,46h			; or if version
	int	67h			; number request
	or	ah,ah			; returns error
	jnz	EmsErrX			; then Error Exit

	mov	si,OFFSET emmshdg	; else store 1st
	mov	cx,EMMLEN1		; heading line
	rep	movsb			; with Version
	call	Val2ASCh		; Major Number
	mov	ah,"."			; plus dot and
	xchg	al,ah			; Minor Number
	dec	di
	stosw
	mov	cx,EMMLEN2		; Add 2nd heading
	rep	movsb			; line lead-in to
	mov	ah,41h			; EMS Page Frame
	int	67h			; If Page Frame
	or	ah,ah			; Request Fails
	jnz	EmsErrX			; then Error Exit
	mov	al,bh			; else store HEX
	call	Val2ASCh		; first two digits
	mov	al,bl			; third and fourth
	call	Val2ASCh		; plus ending
	mov	al,")"			; parenthesis
	stosb
	mov	ax,0A0Dh		; End the line
	stosw
	mov	ah,4Bh			; Get Handle
	int	67h			; Count in BX
	or	ah,ah			; If Response
	jz	EmPages			; then Map Pages

EmsErrX:
	mov	si,OFFSET emserm	; else store
	mov	cx,EMERML		; E M S
	rep	movsb			; Error
	jmp	EmmExit			; Message

EmPages:
	mov	cx,bx			; Set Handle Counter
	inc	cx			; for zero thru [bx]
	xor	dx,dx			; Count up from 0
HndLoop:
	mov	startl,di		; Save Start of Line
	mov	ah,4Ch			; Get Assigned
	int	67h			; Handle Pages
	or	ah,ah			; If Error
	jnz	NoPages			; then skip
	 or	bx,bx			; else if > 0
	 jnz	PagesOk			; then store
NoPages:
	inc	dx			; else loop until
	loop	HndLoop			; CX handles done
	jmp	SHORT HndExit

PagesOk:
	add	di,6			; Position for
	push	dx			; Handle Number
	xor	ax,ax			; Double Word
	xchg	ax,dx			; Digit(s)
	call	BinToDStr
	add	di,9			; Position for
	mov	ax,bx			; Handle Pages
	call	BinToDStr
	add	tpages,ax		; Accumulate Total
	add	di,9			; Position for
	mov	bx,16			; Kilo
	mul	bx			; Bytes
	call	BinToDStr
	pop	dx			; Restore Handle
	add	di,3			; Position for
	mov	ax,5300h		; User Name
	int	67h			; Advance Past
	add	di,8			; Name Area and
	mov	ax,0A0Dh		; End the line
	stosw
	inc	dx			; Increment Handle
	loop	HndLoop			; until CX'em done

HndExit:
	mov	ah,42h			; Get Free
	int	67h			; Pages
	mov	ax,tpages		; Calculate and
	add	ax,bx			; Preserve
	push	ax			; Total Pages
	mov	si,OFFSET freem		; Store the
;v1.1	mov	cx,6			; "  free"
;v1.1	rep	movsb			; lead-in
	movsw				;3 words			v1.1
	movsw
	movsw
	add	di,9			; Position for
	mov	ax,bx			; Free Pages
	xor	dx,dx			; DoubleWord
	call	BinToDStr
	add	di,9			; Position for
	mov	bx,16			; Free Kilo
	mul	bx			; Bytes
	call	BinToDStr
	mov	si,OFFSET dashes+24	; Space Over
	mov	cx,11			; and dash-out
	rep	movsb			; UserName
	mov	ax,0A0Dh		; End the line
	stosw
	mov	si,OFFSET totlm		; Store
;v1.1	mov	cx,6			; " total"
;v1.1	rep	movsb			; lead-in
	movsw				; ' total'			v1,1
	movsw				;lead-in			v1,1
	movsw				;(6 chars)			v1,1
	add	di,9			; Position for
	pop	ax			; Total
	call	BinToDStr		; Pages
	add	di,9			; Position for
	mul	bx			; Total Bytes
	call	BinToDStr
	mov	si,OFFSET dashes+24	; Space Over
	mov	cx,11			; and dash-out
	rep	movsb			; UserName

EmmExit:
	mov	ax,0A0Dh		; End the line
	stosw
	ret
EmmsMap	ENDP

Vectors	PROC
	mov	si,OFFSET watchS	; If the
	mov	di,startl		; Owner
	add	di,23			; Name was NOT
	mov	cx,11			; "TSR WATCHER"
	rep	cmpsb			; Then Check If
	jnz	CkWatch			; Already Installed
	 mov	watchF,ax		; Else Flag Installed
CkWatch:
	mov	di,startl		; Position Index to
	add	di,51			; Start of Vector Area
	cmp	watchF,0		; If NO TSR WATCHER Installed
	jz	UseHook			; Then Use Hooked Vectors
	push	DS			; Else Use Chained
	mov	DS,watchF		; Vectors from Watch
	mov	dx,ax			; Copy Program PSP
	mov	si,104h			; Get Next Vector
	lodsw				; Position in
	mov	si,218h			; Vector Change
	add	ax,220h			; Storage Area
	mov	vpos,ax			; Store for Comparison
	xor	bp,bp			; Zero Vector Counter
FFLoop:	add	si,8			; If Next Record
	cmp	si,vpos			; Is => Table End
	jnc	WatchX			; then exit done
	cmp	BYTE PTR [si],0FFh	; else if NOT pspid
	jne	FFLoop			; or if PSP
	cmp	[si+2],dx		; is NOT desired PSP
	jne	FFLoop			; then keep looking

WatchL:	add	si,8			; If Next Record
	cmp	si,vpos			; is => Table End
	jnc	WatchX			; Then exit done
	cmp	WORD PTR [si],-1	; Else If Next pspid
	jnc	WatchX			; then exit done
	cmp	BYTE PTR [si+1],1	; else if NOT disabled
	jne	WatchV			; then put vectors
	pop	DS			; else restore data
	mov	si,OFFSET disam		; segment of message
	mov	cx,DISALEN		; ***D I S A B L E D
	rep	movsb			; *** and exit
	jmp	SHORT INTExit

WatchV:	cmp	bp,9			; If NOT to last column
	jc	WatchW			; then store Vector
	mov	WORD PTR ES:[di],0A0Dh
	add	di,53			; else start new line
	xor	bp,bp			;  and update counter
WatchW:	mov	ax,[si]			; Get Vector Number
	call	Val2ASCh		; Store 2 HEX ASCII
	inc	di			; digits plus a space
	inc	bp			; Count Vector
	jmp	SHORT WatchL		; Loop until exit

WatchX:	pop	DS			; Restore Data
	jmp	SHORT INTExit		; Segment and Exit

UseHook:
	mov	bp,di			; Copy Pointer
	xor	di,di			; Point ES:DI to
	mov	ES,di			; DOS INT Vectors
	mov	cx,512			; Set Word Count
	mov	dx,4			; and INT Divisor
INTLoop:
	mov	ax,mcbs[bx].pspa	; Scan for PSP in
	repne   scasw			; DOS Vector Table
	mov	ES,sbuffer		; Restore ES:DI to Buffer
	xchg	bp,di			; If at End of Vector Table
	jcxz	INTExit			; then Vectors are Done
	mov	ax,bp			; else Calculate
	div	dl			; Vector Number
	dec	ax			; Zero - Based
	call	Val2ASCh		; Display 2 HEX ASCII
	inc	di			; digits plus a space
	xor	ax,ax			; Reset Extra Segment
	mov	ES,ax			; and Pointer to Vectors
	xchg	bp,di			; preserving MapData Pointer
	mov	ax,startl		; If start of current row
	add	ax,COLUMNS-3		; to position after end
	cmp	bp,ax			; is greater than pointer
	jc	INTLoop			; then loop until end/done
	mov	WORD PTR ES:[bp],0A0Dh
	add	bp,53			; else start new line
	jmp	SHORT INTLoop		; Loop Until Vectors Done

INTExit:
	ret

Vectors	ENDP

	END	Main

	This Version 3.1 revision began with a complaint that
	"garbage was displayed" for certain TSR command lines.

	The cause was a programming error in that a 0 Length
	command line was NOT skipped.  The revision result is
	a ShowTSRs that reverts to the original purpose.  It
	is again compatible with all [F]MarkS, watchS, etc...
	whether from TurboPower or Tom Gilbert's Heart & Mind.

	We are learning from the experience and will welcome comments
	or criticism...  I lied!  We'd rather have help and praise...
