program testinputs;
{ NOTE:  You must run Maketest.pas first to create the resource file that
  is read by this program.

  This program demonstrates three key points of the Tinputs unit:
  1.  Restoring TInputs from a stream
  2.  Using the unit to get user input
  3.  Retrieving that user input when needed.

}

uses objects,views,app,drivers,dialogs,tvinp101;

type Tmyapp = object(TApplication)
end;

{
  This data record reflects the dialog box contructed with the program
  maketest.pas.  The elements of this record agree in type and insertion
  order with the TInputs that were inserted into the dialog box by
  maketest.  Failure to do so will cause unpredictable results.  See
  TGroup.getdata() for more information.
 }

inputdata = record
  in_int : integer;
  in_long : longint;
  in_real : real;
  in_double : double;
  in_single : single;
  in_extended : extended;
  in_comp : comp;
end;

var p : pdialog;
    resource : TResourceFile;  { This is the resource created by maketest }
    myapp : Tmyapp;
    dialog_data : inputdata;


begin
  myapp.init;

{ Don't forget to register those objects you wish to read
  from the stream! }

  registerdialogs;
  RegisterObjects;
  RegisterViews;
  RegisterNumerics;

{ Open the resource }
  resource.init(new(pbufstream,init('tinputs.res',stopen,1024)));

{ Read the dialog box stored there }
  p := pdialog(resource.get('Dialog'));

{ Make sure we know what was previously in the data record }
  fillchar(dialog_data,sizeof(dialog_data),0);

{ Only retrieve data if the OK box was pressed }
  if desktop^.execview(p) = cmOK then begin
    p^.getdata(dialog_data);
  end;

{ Shut things down }
  myapp.run;
  myapp.done;

{ And now display what we've got }
  with dialog_data do begin
    writeln('Last data entered: ');
    writeln('Integer : ',in_int);
    writeln('Longint : ',in_long);
    writeln('Real    : ',in_real);
    writeln('Single  : ',in_single);
    writeln('Double  : ',in_double);
    writeln('Extended: ',in_extended);
    writeln('Comp    : ',in_comp);
  end;
  readln;
end.
