/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TApplication
#define Uses_MsgBox

#include "tvtools.h"
#include "tools.h"
#include <dir.h>
#include <conio.h>
#include <stdlib.h>
#include <process.h>
#include <float.h>


int appSystem( char *cmd )
{
 int status, disk;
 // Should free internal memory pool (draw buffers, overlay buffers,...)
 // This does not work: TProgram::application->freeBuffer();

 // Test if current drive is ready
 disk = getdisk();

 for (;;)
    {
     status = test_drive( disk );

     if ( status & D_INVALID )
        {
         messageBox( mfOKButton,
                     "\03Current disk (%c:) is invalid.",
                     disk + 'A'
                   );
         return cmCancel;
        }

     // OK or write-protected
     if ( status & D_READABLE ) break;

     status = messageBox( mfOKCancel,
                          "\03Please insert a formatted disk\n"
                          "\03in drive %c:",
                          disk + 'A'
                        );
     if ( status != cmOK ) return cmCancel;
    }

 TApplication::application->suspend();
 clrscr();
 if ( cmd ) status = system( cmd );
 else { // Go to DOS and come back
       char *comspec = getenv("COMSPEC");
       if ( ! comspec ) comspec = "COMMAND";
       status = spawnlpe( P_WAIT, comspec, comspec, "/e:2000", NULL, environ );
     }
 _fpreset();  // To reset math co-processor
 TApplication::application->resume();
 TApplication::application->redraw();

 return status;
}
