#define Uses_TApplication
#define Uses_TClockView
#include "tvtools.h"

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <strstrea.h>
#include <iomanip.h>
#include <time.h>



//
// -------------- Clock Viewer functions
//

TClockView::TClockView( TRect& r ) : TView( r )
{
  if ( ! size.x )
     {
       TRect r = TApplication::application->getExtent();
       r.a.x = r.b.x - 9; r.b.y = r.a.y + 1;
       growMode = gfGrowAll;
       moveTo( r.a.x, r.a.y );
       growTo( r.b.x, r.b.y );
       growMode = 0;
     }

  strcpy(lastTime, "        ");
  strcpy(curTime, "        ");
}


void TClockView::draw()
{
    TDrawBuffer buf;
    char c = getColor(2);

    buf.moveChar( 0, ' ', c, size.x );
    buf.moveStr( 0, curTime, c );
    writeLine( 0, 0, size.x, 1, buf );
}


void TClockView::update()
{
    time_t t = time(0);
    char *date = ctime(&t);

    date[19] = '\0';
    strcpy( curTime, &date[11] );        /* Extract time. */

    if ( strcmp(lastTime, curTime) )
       {
         drawView();
         strcpy(lastTime, curTime);
       }
}

