	PAGE	60, 132
TITLE	HDR	22-Sep-88	Device Driver Header			|
SUBTTL	Copyright (c) 1988  Frank E. Whaley				|

;-----------------------------------------------------------------------|
;									|
;	Device Driver Library						|
;		Device Driver Header					|
;									|
;-----------------------------------------------------------------------|

;-----------------------------------------------------------------------|
;	Equates								|
;-----------------------------------------------------------------------|

	INCLUDE	DRIVER.EQU

StkSiz	EQU	2048			; local stack size

	PAGE
;-----------------------------------------------------------------------|
;	Program Segment							|
;-----------------------------------------------------------------------|

	Cseg

	Extrn	_Init:Near,		_MediaCheck:Near,	_BuildBPB:Near
	Extrn	_IoCtlIn:Near,		_Input:Near,		_ndInput:Near
	Extrn	_InputStatus:Near,	_InputFlush:Near,	_Output:Near
	Extrn	_OutVerify:Near,	_OutStatus:Near,	_OutFlush:Near
	Extrn	_IoCtlOut:Near,		_DevOpen:Near,		_DevClose:Near
	Extrn	_RemMedia:Near

	ORG	0

HDR	Proc	Far

;-----------------------------------------------------------------------|
;	Device Header							|
;-----------------------------------------------------------------------|

	DD	-1			; -> next device
	DW	CharacterDevice
	DW	Strategy		; -> device strategy
	DW	Interrupt		; -> device interrupt
	DB	"MON     "

;-----------------------------------------------------------------------|
;	Code Segment Variables						|
;-----------------------------------------------------------------------|

RHptr	DD	(?)			; -> Request Header
ssEntry	DW	(?)			; entry SS
spEntry	DW	(?)			; entry SP

	PAGE
;-----------------------------------------------------------------------|
;	Device Strategy							|
;									|
;	ENTRY :	ES:BX -> Request Header					|
;									|
;	EXIT :	Request Header copied to ReqHdr				|
;		all registers preserved					|
;									|
;-----------------------------------------------------------------------|

Strategy:

	MOV	Word Ptr CS:RHptr,BX	; save request header ptr
	MOV	Word Ptr CS:RHptr + 2,ES

	PUSHF				; (+1) save the world
	PUSH	ES			; (+2)
	PUSH	DS			; (+3)
	PUSH	SI			; (+4)
	PUSH	DI			; (+5)
	PUSH	CX			; (+6)
	PUSH	BX			; (+7)

	MOV	SI,BX
	MOV	BX,ES
	MOV	DS,BX			; DS:SI -> Request Header

	MOV	BX,Offset PGroup:PTail
	MOV	CL,4
	SHR	BX,CL
	MOV	CX,CS
	ADD	BX,CX
	MOV	ES,BX

	MOV	DI,Offset DGroup:_ReqHdr; ES:DI -> ReqHdr
	CLD
	XOR	CH,CH
	MOV	CL,[SI]
	REP	MOVSB			; copy Request Header
	
	POP	BX			; (+6) restore
	POP	CX			; (+5)
	POP	DI			; (+4)
	POP	SI			; (+3)
	POP	DS			; (+2)
	POP	ES			; (+1)
	POPF				; (+0)
	RET

	PAGE
;-----------------------------------------------------------------------|
;	Device Interrupt						|
;									|
;	ENTRY :	anything						|
;									|
;	EXIT :	all registers preserved					|
;									|
;-----------------------------------------------------------------------|

Interrupt:

	PUSH	DS			; (+1) save the world
	PUSH	ES			; (+2)
	PUSH	AX			; (+3)
	PUSH	BX			; (+4)
	PUSH	CX			; (+5)
	PUSH	DX			; (+6)
	PUSH	SI			; (+7)
	PUSH	DI			; (+8)
	PUSH	BP			; (+9)

	MOV	CS:ssEntry,SS		; save entry SS
	MOV	CS:spEntry,SP		; and SP

	MOV	AX,Offset PGroup:PTail	; set our DS, SS, BP, and SP
	MOV	CL,4
	SHR	AX,CL
	MOV	CX,CS
	ADD	AX,CX
	MOV	BX,Offset DGroup:MyStack
	MOV	DS,AX
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,BX
	MOV	BP,BX

	;
	; call our function
	;
	MOV	AL,_ReqHdr + 2		; AL = Command Code
	SHL	AL,1
	CBW
	MOV	SI,Offset DGroup:FuncTab
	ADD	SI,AX
	CALL	Word Ptr [SI]

	;
	; copy back Request Header
	;
	LES	DI,RHptr		; ES:DI -> original space

	MOV	SI,Offset DGroup:_ReqHdr; DS:SI -> our (updated) copy
	CLD
	XOR	CH,CH
	MOV	CL,[SI]
	REP	MOVSB			; copy Request Header

	MOV	SS,CS:ssEntry		; restore original stuff
	MOV	SP,CS:spEntry

	POP	BP			; (+8) restore
	POP	DI			; (+7)
	POP	SI			; (+6)
	POP	DX			; (+5)
	POP	CX			; (+4)
	POP	BX			; (+3)
	POP	AX			; (+2)
	POP	ES			; (+1)
	POP	DS			; (+0)
	RET

HDR	EndP

	EndCS

	PAGE
;-----------------------------------------------------------------------|
;	Data Segment							|
;-----------------------------------------------------------------------|

	Dseg

	Public	_ReqHdr

FuncTab	Label Word
	DW	Offset PGroup:_Init
	DW	Offset PGroup:_MediaCheck
	DW	Offset PGroup:_BuildBPB
	DW	Offset PGroup:_IoCtlIn
	DW	Offset PGroup:_Input
	DW	Offset PGroup:_ndInput
	DW	Offset PGroup:_InputStatus
	DW	Offset PGroup:_InputFlush
	DW	Offset PGroup:_Output
	DW	Offset PGroup:_OutVerify
	DW	Offset PGroup:_OutStatus
	DW	Offset PGroup:_OutFlush
	DW	Offset PGroup:_IoCtlOut
	DW	Offset PGroup:_DevOpen
	DW	Offset PGroup:_DevClose
	DW	Offset PGroup:_RemMedia

	EndDS

	Useg

_ReqHdr	DB	256 Dup (?)		; copy of Request Header

	DB	StkSiz Dup (?)		; our stack, overflows into ReqHdr
MyStack	Label	Word

	EndUS

	END	HDR			; of HDR.ASM
