/* 'filter' v. 1.4 -- Oct. 8, 1992  by Joel Polowin
* Multiple-term text search utility
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define LENGTH 301 /* 1 more than max # characters in text lines */
#define ARGS 15   /* max # search strings */

void main(argc,argv)
int argc;
char *argv[];
{
   char line[LENGTH],lowline[LENGTH];
   FILE *infile;
   int i,test,startarg,lowcase;
   void syntax();
   void strlow();
   char flag[ARGS+3],orflag[ARGS+3];

   if(argc<=1 || argc>ARGS+2 || ((!(test=(*argv[1]=='+' || *argv[1]=='-' ||
     *argv[1]=='_' || *argv[1]=='=' ))) && argc==2) || ((argc==ARGS+2)&&
     test)) 
     {
     fprintf(stderr,"Bad number of strings.\n");
     syntax();
     }
   
   startarg=2;
   lowcase=0;
   
   if(test)
      {
      startarg=1;
      infile=stdin;
      }
   else if(!(infile=fopen(argv[1],"r")))
      {
      fprintf(stderr,"Can't open file %s for reading.\n",argv[1]);
      syntax();
      }

   for (i=startarg;i<argc;i++) orflag[i-1]=0;

   for (i=startarg;i<argc;i++)
   {
      switch(*argv[i])
      {
	 case '+':
	    strlow(argv[i]);
	    lowcase=1;
	 case '=':
	    flag[i]=1;
	    break;
	 case '-':
	    strlow(argv[i]);
	    lowcase=1;
	 case '_':
	    flag[i]=0;
	    break;
	 case 'O':
	 case 'o':
	    orflag[i-1]=1;
	    argv[i]++;
	    i--;
	    break;
	 default:
	    fprintf(stderr,"Error in string no. %d: %s\n",i-1,argv[i]);
	    syntax();
      }
   }
   orflag[i-1]=0;

   for (;;)
      {
      if(NULL==fgets(line,LENGTH,infile)) break;
      if(LENGTH==strlen(line)+1) fprintf(stderr,"* Warning: truncated line \n%s\n",line);
      if(lowcase) strlow(strcpy(lowline,line));
      for(i=startarg;i<argc;i++)
	 {
	 test=0;
	 switch(*argv[i])
	    {
	    case '=':
	    case '_':
	       if(NULL!=strstr(line,(argv[i]+1))) test=1;
	       break;
	    default:
	       if(NULL!=strstr(lowline,(argv[i]+1))) test=1;
	       break;
	    }
	 if(test!=flag[i] && orflag[i]==0) break;
	 if(test==flag[i])
	    while(orflag[i]==1) i++;
	 }
      if(i==argc) printf("%s",line);
      }
   if(infile!=stdin) fclose(infile);
}

void strlow(string)
char *string;
{
   while (*string!='\0')
   {
      *string=tolower(*string);
      string++;
   }
}

void syntax ()
{
   fprintf(stderr,"Syntax: filter [filename] string1 [string2 ...]\n  where each");
   fprintf(stderr," string (max. of %d) is a term to be searched for",ARGS);
   fprintf(stderr," in lines (max.\n  %d chars) in file",LENGTH-1);
   fprintf(stderr," `filename', prefixed by one of the following characters:\n");
   fprintf(stderr,"    +  to show lines which contain string\n");
   fprintf(stderr,"    -  to show lines which do not contain string\n");
   fprintf(stderr,"    =  to show lines which contain string, case sensitive\n");
   fprintf(stderr,"    _  (underscore) to show lines which do not contain string,\n");
   fprintf(stderr,"            case sensitive\n\n");
   fprintf(stderr,"A string as above may be further prefixed with the letter 'o' to\n");
   fprintf(stderr,"  print the line if the current OR the preceding condition is true.");
   fprintf(stderr,"\nA string including blanks and the prefix may be enclosed in");
   fprintf(stderr," double quotes.\n\nExamples:\n  filter armorial =Vert +argent ");
   fprintf(stderr,"-gules _Or -azure -purpur +foil > tempfile.txt\n");
   fprintf(stderr,"  type temp1.txt | filter +aardvark \042o+winged pig\042 ");
   fprintf(stderr,"o+wombat \042_|B|\042\n\nFilter utility v.1.4 (C) 1992 by Joel Polowin, Chem. ");
   fprintf(stderr,"Dept., Queen's University,\nKingston.  Permission granted for free ");
   fprintf(stderr,"use; I want credit/blame for writing it.\n");
   fprintf(stderr,"polowin@silicon.chem.queensu.ca, polowinj@qucdn.queensu.ca\n");
   exit(0);
}




       
