/*
	RegTable.HPP version 1.0
	by Robert Schmidt of Ztiff Zox Softwear 1993

	Declares the RegisterTable class and its members, defined in
		RegTable.CPP.
*/

#ifndef _RegTable_HPP
#define _RegTable_HPP

#include "Register.HPP"


class RegisterTable
	{
	NamedRegister *reg;
	int registers, select, prevSel;
public:
	RegisterTable(const char*);
	~RegisterTable()			{ delete[] reg; }

	int operator++()			{ return setSelect(select+1); }
	int operator--()			{ return setSelect(select-1); }
	NamedRegister& operator* (void) { return reg[select]; }
	int getMaxReg()				{ return registers-1; }
	int getSelect()				{ return select; }
	void printCon(int);
	void printAllCon();
	int updateSelect();
	int setSelect(int s)		{ select = s; return updateSelect(); }
	void showBitMask();
	void doEnable()				{ for (int r=0; r<registers; r++)
									reg[r].doEnable(); }
	void doDisable()			{ for (int r=0; r<registers; r++)
									reg[r].doDisable(); }
	void in();
	void out();

	friend istream& operator>> (istream&, RegisterTable&);
	friend ostream& operator<< (ostream&, RegisterTable&);
	};

#endif