/*
 * $Id: cmdline.c 1.0 91/08/14 13:20:58 montgomery Rel $
 *
 * $Revision: 1.0 $
 */

		#include "poll.h"


int ProcessCmdLine(int argc, char *argv[], struct COMMANDVALUES *CommandValues)
     {
     char buf[256], *szNum;
     int ArgcSiteStart=1;
     time_t t;
     strcpy(buf,CopyCmdLine(argc, argv));
     if (argc < 4)
	PrintUsageAndExit();
     if (!(szNum=GetSwitch(buf,"-s")))
	PrintUsageAndExit();
     ArgcSiteStart++;
     CommandValues->SecondsToWait=atol(szNum);
     if (!(szNum=GetSwitch(buf,"-t")))
	PrintUsageAndExit();
     ArgcSiteStart++;
     CommandValues->tries=atoi(szNum);
     if ((CommandValues->tries == 0) || (CommandValues->SecondsToWait == 0))
	PrintUsageAndExit();
     if (!(szNum=GetSwitch(buf,"-x")))
	CommandValues->debug= NO_XSWITCH;
     else
	{
	ArgcSiteStart++;
	CommandValues->debug=atoi(szNum);
	}
     if (GetSwitch(buf,"-d") == (char *) TRUE)
	{
	DebugPoll = TRUE;
	ArgcSiteStart++;
	fDebug=fopen("poll.log","at");
	fprintf(fDebug, "\nPoll - v%s -- Copyright (C) 1991 by Greg Montgomery\n\n",
			      (char *) &szRev[11]);

	time(&t);
	fprintf(fDebug,"%s\n", ctime(&t));
	fprintf(stderr,"Debugging output is on\n");
	fprintf(fDebug,"Debugging output is on\n");
	fprintf(stderr,"\nDebug level is %d\t\tNumber of tries is %d\nSeconds to wait between tries is %ld\n",CommandValues->debug,CommandValues->tries,CommandValues->SecondsToWait);
	fprintf(fDebug,"\nDebug level is %d\t\tNumber of tries is %d\nSeconds to wait between tries is %ld\n",CommandValues->debug,CommandValues->tries,CommandValues->SecondsToWait);
	}
     CommandValues->NumSites=argc-ArgcSiteStart;
     if (CommandValues->NumSites < 1)  // no sites on command line
	PrintUsageAndExit();
     return ArgcSiteStart;
     }


char *GetSwitch(char buf[], char *option)
     {
     char *ptr;
     int i;
     char szNum[32];
     if (!(ptr=strstr(buf, option)))
	return NULL;
     if (!strcmp(option,"-d") && strstr(buf,"-d"))
	return (char *)TRUE;
     ptr+=2;
     strcpy(szNum, ptr);
     for (i=0 ; szNum[i] != '|'; i++) ;
     szNum[i] = '\0';
     return szNum;
     }

char *CopyCmdLine(int argc, char *argv[])
     {
     char buf[256]={0};
     int i;
     for (i=0; i < argc; i++)
	{
	strcat(buf,argv[i]);
	strcat(buf,"|");
	}
     return buf;
     }


void PrintUsageAndExit(void)
     {
     printf("Usage: poll { switches } sitename [sitename...]\n\n");
     printf("\t-s xxx     *  Seconds between calls\n");
     printf("\t-t xxx     *  Max. Calls for each site\n");
     printf("\t-x xxx        Debug level for uucico\n");
     printf("\t-d            Turns Debugging output on\n");
     printf("\tsitename   *  Name(s) of sites to poll\n");

     printf("\nSwitches with a '*' are mandatory.\n");
     exit(1);
     }
