{

rusn-io.pas - nonconsole input/output routines

assumes a fossil (if the nonconsole routines will ever be used)

requires:

uses dos,crt;
global variables
  console: boolean, port: integer, minutes: integer,
  minstart: integer, trusted: boolean, shadow: integer;
  lowcolor: byte, highcolor: byte;


shortcomings:

minimal ansi/vt100 hard-coded in
8-bit non-clean - assumes all input >126 is line noise (easily fixed)

}

procedure noncwritec(c: char);

var
  regs: registers;

begin
  regs.dx := port;
  regs.ah := 1;
  regs.al := ord(c);
  intr($14,regs);
end;

function noncreadc: char;

var
  regs: registers;

begin
  regs.dx := port;
  regs.ah := 2;
  intr($14,regs);
  noncreadc := chr(regs.al);
end;

function noncinready: boolean;

var
  regs: registers;

begin
  regs.dx := port;
  regs.ah := 3;
  intr($14,regs);
  noncinready := odd(regs.ah);
end;

procedure xwrites(s: string);

var
  i: integer;

begin
  if console then
    write(s)
  else
    begin
      for i := 1 to length(s) do
        noncwritec(s[i]);
      if shadow>0 then
        begin
          write(s);
          delay(shadow);
        end;
    end;
end;

procedure xwritei(i: integer);

var
  s: string;

begin
  if console then
    write(i)
  else
    begin
      str(i,s);
      xwrites(s);
    end;
end;

procedure xwriteiw(i,w: integer);

var
  s: string;

begin
  if console then
    write(i:w)
  else
    begin
      str(i:w,s);
      xwrites(s);
    end;
end;

procedure xwritess(s1,s2: string);

begin
  xwrites(s1);
  xwrites(s2);
end;

procedure xwritesss(s1,s2,s3: string);

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
end;

procedure xwritessss(s1,s2,s3,s4: string);

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
  xwrites(s4);
end;

procedure xwritesis(s1: string; i2: integer; s3: string);

begin
  xwrites(s1);
  xwritei(i2);
  xwrites(s3);
end;

procedure xwritessis(s1,s2: string; i3: integer; s4: string);

begin
  xwritess(s1,s2);
  xwritei(i3);
  xwrites(s4);
end;

procedure xwriteln;

begin
  if console then
    writeln
  else
    xwritess(chr(13),chr(10));
end;

procedure xwritelns(s: string);

begin
  xwrites(s);
  xwriteln;
end;

procedure xwritelnss(s1,s2: string);

begin
  xwrites(s1);
  xwrites(s2);
  xwriteln;
end;

procedure xwritelnsss(s1,s2,s3: string);

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
  xwriteln;
end;

procedure xwritelnssss(s1,s2,s3,s4: string);

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
  xwrites(s4);
  xwriteln;
end;

procedure xwritelnsi(s1: string; i2: integer);

begin
  xwrites(s1);
  xwritei(i2);
  xwriteln;
end;

procedure xwritelnsssisis(s1,s2,s3: string; i4: integer; s5: string;
 i6: integer; s7: string);

begin
  xwritesss(s1,s2,s3);
  xwritei(i4);
  xwrites(s5);
  xwritei(i6);
  xwritelns(s7);
end;

procedure xgotoxy(x,y: integer);

begin
  if console then
    gotoxy(x,y)
  else
    begin
      xwritess(#27,'[');
      xwritei(y);
      xwrites(';');
      xwritei(x);
      xwrites('f');
    end;
end;

procedure writexy(x,y: integer; s: string);

begin
  xgotoxy(x,y);
  xwrites(s);
end;

procedure xclreol;

begin
  if console then
    clreol
  else
    xwritess(#27,'[0K');
end;

procedure xclreolxy(x,y: integer);

begin
  xgotoxy(x,y);
  xclreol;
end;

procedure xclrscr;

begin
  if console then
    clrscr
  else
    begin
      xwritess(#27,'[2J');
      xgotoxy(1,1);
    end;
end;

function xkeypressed: boolean;

var
  minnow: integer;

begin
  if console then
    xkeypressed := keypressed
  else
    begin

{check for timeout _before_ checking if a key is ready - modems can spew}

      if not trusted then
        begin
          minnow := mitoday;
          if minnow<minstart then
            inc(minnow,24*60);
          if minnow-minstart>=minutes then
            begin
              xwriteln;
              xwritelns('time up');
              xwriteln;
              halt(2);
            end;
        end;

      xkeypressed := noncinready or keypressed;
    end;
end;

function xreadkey: char;

var
  result: char;

begin
  if console then
    begin

{ ignore function keys, alt keys, numeric pad keys - translate to ' ' }

      repeat
        result := readkey;
        if (result=#0) and keypressed then
          begin
            result := readkey;

{ change these extended keys: }

{    key pressed    code returned }
{    -----------    ------------- }
{    PgUp           <             }
{    PgDn           space or >    }
{    Home           ^             }
{    End            $             }
{    F1             ?             }
{    left arrow     backspace     }
{    alt-J          !             }

{ ignore other extended keys }

            if result='I' then
              result := '<'
{$ifdef pgdnbecomesgt}
            else if result='Q' then
              result := '>'
{$else}
            else if result='Q' then
              result := ' '
{$endif}
            else if result='G' then
              result := '^'
            else if result='O' then
              result := '$'
            else if result=';' then
              result := '?'
            else if result='K' then
              result := #8
            else if result='$' then
              result := '!'
            else
              result := #0;
          end;
      until result<>#0;
    end
  else
    begin
      while not xkeypressed do
        ;
      if keypressed then
        result := readkey
      else
        result := noncreadc;
    end;
  xreadkey := result;
end;

procedure xreadlns(var s: string; maxlen: integer);

var
  result: string;
  len: integer;
  c: char;

begin
  len := 0;
  result := '';
  repeat
    c := xreadkey;
    if (c=#127) or (c=#8) then
      begin
        if length(result)>0 then
          begin
            xwritesss(#8,' ',#8);
            dec(len);
            if len=0 then
              result := ''
            else
              result := copy(result,1,len);
          end;
      end
    else if (c=#13) then
      begin
{$ifdef xwritelnafterxreadln}
        xwriteln;
{$endif}
      end
    else if (ord(c)>=32) and (ord(c)<128) and (len<maxlen) then
      begin
        inc(len);
        result := result+c;
        if console then
          write(c)
        else
          noncwritec(c);
      end
  until c=#13;
  s := result;
end;

procedure xhighvideo;

begin
  if console then
    textcolor(highcolor)
  else
    xwritess(#27,'[7m');
end;

procedure xlowvideo;

begin
  if console then
    textcolor(lowcolor)
  else
    xwritess(#27,'[m');
end;