/* invid.c */

#include <windows.h>
#include "invid.h"

struct decodeWord {
	WORD Code;
	LONG (*Fxn)(HWND, WORD, WORD, LONG); };

struct decodeWord messages[] = {
	WM_CREATE, DoCreate,
	WM_DESTROY, DoDestroy, } ;



int PASCAL WinMain (HANDLE hInstance,
	HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	MSG msg ;
	if (!hPrevInstance) InitApplication(hInstance);
	InitInstance(hInstance, nCmdShow);

	while (GetMessage (&msg, NULL, 0, 0))
	{
		TranslateMessage (&msg) ;
		DispatchMessage (&msg) ;
	}

	return (msg.wParam) ;
}


BOOL InitApplication(HANDLE hInstance)
{
	WNDCLASS wndclass;

	wndclass.style = 0 ;
	wndclass.lpfnWndProc = WndProc ;
	wndclass.cbClsExtra = 0 ;
	wndclass.cbWndExtra = 0 ;
	wndclass.hInstance = hInstance ;
	wndclass.hIcon = LoadIcon (hInstance, szAppName) ;
	wndclass.hCursor = LoadCursor (hInstance, IDC_ARROW) ;
	wndclass.hbrBackground = GetStockObject (BLACK_BRUSH) ;
	wndclass.lpszMenuName = NULL ;
	wndclass.lpszClassName = szAppName ;

	return(RegisterClass (&wndclass));
}


BOOL InitInstance(HANDLE hInstance, WORD nCmdShow)
{
	hWnd = CreateWindow (szAppName,
		"Invid",
		DS_SYSMODAL | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
		CW_USEDEFAULT, CW_USEDEFAULT,
		WINDOW_WIDTH, WINDOW_HEIGHT ,
		NULL,
		NULL,
		hInstance,
		NULL) ;

	ShowWindow (hWnd, nCmdShow) ;
	UpdateWindow (hWnd) ;
	return (TRUE);
}


long FAR PASCAL WndProc (HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	int i;

	for(i=0; i < dim(messages); i++)
	{
		if(wMsg == messages[i].Code)
			return((*messages[i].Fxn)(hWnd, wMsg, wParam, lParam));
	}

	return(DefWindowProc(hWnd, wMsg, wParam, lParam));
}


LONG DoCreate(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
return 0;
}


LONG DoDestroy(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	PostQuitMessage (0) ;
	return 0 ;
}

