#include    "userrec.h"  

// set-up the stack 
extern unsigned _stklen = 128000U;

extern  configrec     syscfg;         // holds info from config.dat 
extern  mailu         u;              // holds mailu 
extern  int           local,          // flag for local usage 
                      ansi,           // flag for ansi usage 
                      nowrite,        // write user files ? 
                      logoff,         // should the door logoff 
                      import,         // flag for import mode
                      export;         // flag for export mode 
static  userrec       user;           // your userrec  
//===================================================================
void convert_to()
{
        // transfers your userrec info into my mailu structure 
        
        strcpy(u.name, user.name);
        u.screenlines     = user.screenlines;
        u.sl              = user.sl;
        u.dsl             = user.dsl;
        u.waiting         = user.waiting;
        u.age             = user.age;
        u.ar              = user.ar;
        u.dar             = user.dar;
        u.restrict        = user.restrict;
        u.msgpost         = user.msgpost;
        u.posttoday       = user.posttoday;
        u.daten           = user.daten;
        u.gold            = user.gold;
        u.postnet         = user.postnet;
}
//===================================================================
void convert_from()
{
        // transfers my mailu info to your userrec structure
        // BTW: WWIVMail/QWK only updates these fields, so the entire
        // userrec doesn't need to be updated 
        
        user.waiting         = u.waiting;
        user.msgpost         = u.msgpost,
        user.posttoday       = u.posttoday;
        user.gold            = u.gold;
        user.postnet         = u.postnet;
}
//===================================================================
int get_user
(
int num, 
userrec *user_data,
int *num_userrecs
)
{
    unsigned long pos;
    int userfile, iret = 0;
    char line[MAXPATH];


    // number of possible users found
    *num_userrecs = 0;

    // actually open the user file 
    sprintf(line, "%sUSER.LST", syscfg.datadir);
    if ((userfile = open(line, O_RDWR | O_BINARY)) != -1) {

        *num_userrecs = ((int)(filelength(userfile)/syscfg.userreclen) - 1);

        // goto and read a specific user
        pos = (long)num * syscfg.userreclen;
        if (lseek(userfile, pos, SEEK_SET) != -1L)  
            if (read(userfile, user_data, syscfg.userreclen) > 0) {
                if (user_data->inact & inact_deleted)
                    iret = 0;
                else
                    iret = 1;
            }
        close(userfile);
    }

    return(iret);
} 
//===================================================================
int put_user
(
int num, 
userrec *user_data
)
{
    unsigned long pos;
    int userfile, iret = 0;
    char line[MAXPATH];

    // actually open the user file 
    sprintf(line, "%sUSER.LST", syscfg.datadir);
    if ((userfile = open(line, O_RDWR | O_BINARY)) != -1) {

        // goto and write a specific user
        pos = (long)num * syscfg.userreclen;
        if (lseek(userfile, pos, SEEK_SET) != -1L) 
           if (write(userfile, user_data, syscfg.userreclen) > 0)
                iret = 1;

        close(userfile);
    }

    return(iret);
}
//===================================================================
void freshen_mailu_and_qscn
(
int *user_num
)
{
    // reads from your userrec and updates the mailu/qsc information
    int num_userrecs;

    if (get_user(*user_num, &user, &num_userrecs)) {
        convert_to();
        Read_Qscn(*user_num);
    } else
        *user_num = 0;
}
//===================================================================
void read_user_info
(
int *user_num, 
char *cur_baud, 
char *com_speed
)
{
        // opens user file and chain.txt to get info for userrec 

        int advance;
        char line[81];
        FILE *chain;

        // local mode
        if(local){
            if (export) {
                // user_num is already set
                ansi = 1;
            } else if (import) {
                *user_num = 1;
                ansi = 1;
            } else {
                cout << "\n";
                cout << "Please Enter User Number:";
                gets(line);
                *user_num = (int)atoi(line);
                cout << "Do You Have Local ANSI ? (Y/N)";
                gets(line);
                // turn on/off ansi graphic output 
                if (strcmp(strupr(line),"Y") == 0)
                    ansi = 1;
                else
                    ansi = 0;
            }
            strcpy(cur_baud, "KB");
            strcpy(com_speed, "0");
            // remote user 
        } else {
            // line 1 of chain.txt has user number 
            chain = fopen("chain.txt", "r");
            fgets(line, 80, chain);
            *user_num = (int)atoi(line);
                
            // skip on down to ansi support line 
            for(advance = 1; advance < 14; advance++)
                fgets(line, 80, chain);
            ansi = atoi(line);

            // skip on down to current baud rate 
            for(advance = 1; advance < 7; advance++)
                fgets(line, 80, chain);
            strcpy(cur_baud, "");
            strncat(cur_baud, line, strlen(line) - 1);

            // skip on down to current com_speed 
            for(advance = 1; advance < 12; advance++)
                fgets(line, 80, chain);
            strcpy(com_speed, "");
            strncat(com_speed, line, strlen(line) - 1);

            fclose(chain);
        }

        freshen_mailu_and_qscn(user_num); 
}
//===================================================================
void write_user
(
int user_num, 
char *main_dir, 
int clean
)
{
        // Open the user file and update the last read pointers 

        cd_to(main_dir);

        if ((nowrite == 0) && clean)
            delmail(user_num);

        convert_from();

        if (nowrite == 0)
            put_user(user_num, &user);
        Write_Qscn(user_num);
        Read_Qscn(user_num);

        cd_to(syscfg.tempdir);
}
//===================================================================
void user_ssm
(
int un
)
{
        // tells a user that he/she has one more piece of
        // short message to read 

        userrec tempuser;
        int num_userrecs;
        
        if (get_user(un, &tempuser, &num_userrecs)) {        
            if (nowrite == 0) {
                tempuser.sysstatus |= sysstatus_smw;
                put_user(un, &tempuser);
            }
        }
}
//===================================================================
void user_import
(
int un
)
{
        // tells a user (local) that he/she has one more piece of
        // e-mail to read 
           
        userrec tempuser;
        int num_userrecs;

        if (get_user(un, &tempuser, &num_userrecs)) {
            if (nowrite == 0) {
                tempuser.waiting++;
                put_user(un, &tempuser);
            }
        }
}
//===================================================================
void mail_forward
(
int un, 
ushort *touser, 
ushort *tosys, 
ushort *net_num
)
{
        // tells if a user has his/her e-mail forwarded 
           
        userrec tempuser;
        int num_userrecs;
    
        *touser = *tosys = *net_num = 0;    
        if (get_user(un, &tempuser, &num_userrecs)) {
            *touser = tempuser.forwardusr;
            *tosys  = tempuser.forwardsys;
            *net_num = tempuser.net_num;
        }
}
//===================================================================
void get_user_name
(
int un,
char *name,
int *num_userrecs
)
{
        // returns a user's name...used for e-mail

        userrec tempuser;
    
        if (get_user(un, &tempuser, num_userrecs)) {
            strcpy(name, tempuser.name);
        } else
            name = '\0';
}
//===================================================================
void main(int argc, char *argv[])
{
    // this is a stub for the REAL main() routine. 

    realmain(argc, argv);
}
//===================================================================
