#include <bios.h>
#include <go32.h>
#include <dpmi.h>
#include <stdlib.h>

long biostime(int cmd, long newtime)
{
  _go32_dpmi_registers r;
  memset(&r, 0, sizeof(r));
  r.h.ah = cmd;
  r.x.cx = newtime >> 16;
  r.x.dx = newtime & 0xffff;
  _go32_dpmi_simulate_int(0x1a, &r);
  return (r.x.cx << 16) | r.x.dx;
}
