/* CONFISET
 * Exports DR-DOS's config environment variables to a file.
 * This C routine is called from an assembler routine, making it a device
 * driver file.
 *
 * Written using Borland C++, by JohnPC 1992.
 */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <dos.h>
#include <string.h>
#include <sysrlst.h>
#include <errno.h>

/* Maximal environment size */
#define MAXENV 0x7FFF

/* Maximal string length */
#define STRLEN 256

/* The standard output handle */
#define STDOUT 1

/* Turn off 'Possibly incorrect assignment' warning */
#pragma warn -pia

/* define byte and word */
typedef unsigned char byte;
typedef unsigned word;

/* The structure that is passed to the initialisation call of a
	device driver. Only the configstr and endofres fields are used here. */

struct devinit {
	byte length;
	byte unitnum;
	byte command;
	word status;
	byte reserved[8];
	byte numofunits;
	void far* endofres;
	char far* configstr;
	byte drivenum;
};

/* External functions and variables:
	int isdrdos()
		checks if DR-DOS is the OS. returns -1 if true, else returns 0
	char far* getcenv()
		returns a pointer to the config environment, and clears the internal
		pointer to indicate that it's used.
	endofprog
		label to the first byte after the code. Used to point to free space */

extern int isdrdos(void);
extern char far* getcenv(void);
extern endofprog;

/* Define a temporary string after the end of the code */
char* tmpstr = (char*) &endofprog;

char* processenv(char*);
int goodenv(char far*);
char* getarg(char*);

/* initialise
	Main routine, called from assembler. */

void initialise(struct devinit far* di) {
	_fstrncpy(tmpstr, di->configstr, STRLEN); /* Copy string to local */
	strcpy(tmpstr, processenv(tmpstr)); /* Process, and save return message */
	if ( errno ) /* If error, append colon and error message */
		strcat(strcat(tmpstr, ": "), _sys_errlist[min(errno, __sys_nerr)]);
	strcat(tmpstr, "\r\n"); /* Add a CR, LF */
	_write(STDOUT, tmpstr, strlen(tmpstr)); /* Write result message */
	di->endofres = MK_FP(_CS, 0); /* Set nothing remains resident */
}

/* processenv
	Process the argument string, creat the file, write the environment and
	return a message. */

char* processenv(char* args) {
	char* filename;
	int fh;
	char far* env;
	int len;

	if ( ! (filename = getarg(args)) ) /* Get the filename */
		return "Specify a filename";
	if ( ! isdrdos() ) /* Check for DR-DOS */
		return "DR-DOS is required";
	if ( (fh = _creat(filename, FA_ARCH)) == -1 ) /* Create the file */
		return "Cannot creat file";
	if ( ! (env = getcenv()) ) /* Get the environment */
		return "Config environment already used";
	if ( (len = goodenv(env)) == -1 ) { /* Get length of environment */
		_close(fh);
		errno = EINVENV; /* Invalid environment error */
		return "Memory probably overwritten";
	}
	while ( len > 0 ) { /* Write environment to file */
		_fmemcpy(tmpstr, env, STRLEN); /* Copy a chunk to local memory */
		if ( _write(fh, tmpstr, min(STRLEN, len)) == -1 ) { /* Write it */
			_close(fh);
			return "Cannot write file";
		}
		env += STRLEN; /* Next chunk */
		len -= STRLEN;
	}
	if ( _close(fh) == -1 ) /* Close the file */
		return "Cannot close file";
	else
		return "";
}

/* goodenv
	Process and check the environment. If OK, returns the lenght, else
	returns -1. */

int goodenv(char far* env) {
	unsigned strlength, length;
	int had_equal;

	if ( *env == 0 ) /* Check if environment empty */
		return *++env == 0 ? 0 : -1; /* Environment bad if not two zero's */
	length = 0; /* Set total length zero */
	do {
		strlength = had_equal = 0;
		do {
			if ( ( *env < ' ' && *env != '\t' ) || *env == '\x7F' )
				return -1; /* If bad character */
			if ( ! (had_equal |= (*env == '=')) && *env >= 'a' && *env <= 'z' )
				*env &= ~ ('a' - 'A'); /* make uppercase before equal sign */
			env++; /* Next character */
			if ( ++strlength > STRLEN ) /* Check max variable length */
				return -1;
		} while ( *env );
		*env++ = '\n'; /* Place return character at end of string */
		if ( ! had_equal || (length += ++strlength) > MAXENV )
			return -1; /* If no equal sign, or total environment too big */
	} while ( *env );
	return length;
}

/* getarg
	Returns a pointer to the filename in the argument string, or
	NULL if zero or too many arguments. */

char* getarg(char* c) {
	char* r;

	strtok(c, "\r\n"); /* config gives a CR or LF terminated string */
	if ( ! strtok(c, " \t") || ! (r = strtok(NULL, " \t")) ||
			strtok(NULL, " \t") )
		return NULL; /* If no first, no second, or a third arg does exist */
	return r; /* return second arg */
}
