-- Problem 4.4
-- by Rick Conn
with Text_IO;
procedure Main is

  task type Display is
    entry Start (Task_Name : in STRING;
                 Delay_Amt : in DURATION);
  end Display;

  task body Display is
    T_Name       : STRING(1..80);
    TNLast       : NATURAL;
    Delay_Amount : DURATION;
  begin
    accept Start (Task_Name : in STRING;
                  Delay_Amt : in DURATION) do
      T_Name (1..Task_Name'LENGTH) := Task_Name;
      TNLast                       := Task_Name'LENGTH;
      Delay_Amount                 := Delay_Amt;
      Text_IO.Put_Line ("Task " & T_Name(1..TNLast) & " starting");
    end Start;
    delay Delay_Amount;
    Text_IO.Put_Line ("Task " & T_Name(1..TNLast) & " ending");
  end Display;

begin -- Main

  declare
    Tasks : array (1..5) of Display;
  begin
    for I in Tasks'RANGE loop
      Tasks(I).Start
          ("Task" & INTEGER'IMAGE(I), DURATION(Tasks'LAST+1 - I));
    end loop;
  end;

end Main;
