-- *******************************************
-- *                                         *
-- *  Automobile_Interface                   *  SPEC
-- *                                         *
-- *******************************************
package Automobile_Interface is

  Maximum_Speed : constant := 120.0;
  type SPEED is new FLOAT
      range 0.0 .. Maximum_Speed;  -- MPH

  -- ...........................................
  -- .                                         .
  -- .  Automobile_Interface.Turn_On_Engine    .  SPEC
  -- .                                         .
  -- ...........................................
  procedure Turn_On_Engine;
  --| Purpose
  --|    Turn on the automobile engine.  The Brake
  --| Pedal and Accelerator Pedal routines are
  --| activated.

  -- ...........................................
  -- .                                         .
  -- .  Automobile_Interface.Turn_Off_Engine   .  SPEC
  -- .                                         .
  -- ...........................................
  procedure Turn_Off_Engine;
  --| Purpose
  --|    Turn off the automobile engine.  The Brake
  --| Pedal and Accelerator Pedal routines are
  --| deactivated and the car comes to a stop.

  -- ....................................................
  -- .                                                  .
  -- .  Automobile_Interface.Depress_Accelerator_Pedal  .  SPEC
  -- .                                                  .
  -- ....................................................
  procedure Depress_Accelerator_Pedal;
  --| Purpose
  --|    The car accelerates.
  --|
  --| Notes
  --|    Turn_On_Engine must first be called.

  -- ....................................................
  -- .                                                  .
  -- .  Automobile_Interface.Hold_Accelerator_Pedal     .  SPEC
  -- .                                                  .
  -- ....................................................
  procedure Hold_Accelerator_Pedal;
  --| Purpose
  --|    The car stops accelerating and holds a steady speed.
  --|
  --| Notes
  --|    Turn_On_Engine must first be called.

  -- ....................................................
  -- .                                                  .
  -- .  Automobile_Interface.Release_Accelerator_Pedal  .  SPEC
  -- .                                                  .
  -- ....................................................
  procedure Release_Accelerator_Pedal;
  --| Purpose
  --|    The car stops accelerating and starts to
  --| decelerate.
  --|
  --| Notes
  --|    Turn_On_Engine must first be called.

  -- ..............................................
  -- .                                            .
  -- .  Automobile_Interface.Depress_Brake_Pedal  .  SPEC
  -- .                                            .
  -- ..............................................
  procedure Depress_Brake_Pedal;
  --| Purpose
  --|    The car decelerates quickly.
  --|
  --| Notes
  --|    Turn_On_Engine must first be called.

  -- ..............................................
  -- .                                            .
  -- .  Automobile_Interface.Release_Brake_Pedal  .  SPEC
  -- .                                            .
  -- ..............................................
  procedure Release_Brake_Pedal;
  --| Purpose
  --|    The car decelerates at the same speed as
  --| it does if Release_Accelerator_Pedal is called.
  --|
  --| Notes
  --|    Turn_On_Engine must first be called.

  -- ...........................................
  -- .                                         .
  -- .  Automobile_Interface.Sensed_Speed      .  SPEC
  -- .                                         .
  -- ...........................................
  function Sensed_Speed return SPEED;
  --| Purpose
  --|    Return the speed of the car.

  -- ...........................................
  -- .                                         .
  -- .  Automobile_Interface.Update            .  SPEC
  -- .                                         .
  -- ...........................................
  procedure Update;
  --| Purpose
  --|    Update the status of the car.  This routine
  --| should be called periodically, and it advances
  --| the state of the car to the next second.

end Automobile_Interface;
