-- ********************************************
-- *                                          *
-- *  Buoy_Sensor_Interface                   *  SPEC
-- *                                          *
-- ********************************************
package Buoy_Sensor_Interface is

  type BUOY_ID is (B01, B02, B03, B04, B05,
                   B06, B07, B08, B09, B10,
                   B11, B12, B13, B14, B15,
                   B16, B17, B18, B19, B20);

  type OFF_ON is (OFF, ON);

  type TEMPERATURE is new FLOAT
      range -100.0 .. 300.0;     -- Fahrenheit

  type SPEED is new FLOAT
      range 0.0 .. 200.0;        -- MPH

  type NSEW is (NORTH, SOUTH, EAST, WEST);
  type DEGREE is new FLOAT
      range 0.0 .. 90.0;         -- Degrees
  type COORDINATE is record
    Direction : NSEW;
    Offset    : DEGREE;
  end record;
  type LOCATION is record
    Latitude  : COORDINATE;
    Longitude : COORDINATE;
  end record;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Air_Temperature    .  SPEC
  -- .                                           .
  -- .............................................
  function Air_Temperature (ID : in BUOY_ID)
      return TEMPERATURE;
  --| Purpose
  --|    Return the Air Temperature around the buoy.
  --|
  --| Notes
  --|    Update must be called to update the status
  --| of the buoy sensors first.

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Water_Temperature  .  SPEC
  -- .                                           .
  -- .............................................
  function Water_Temperature (ID : in BUOY_ID)
      return TEMPERATURE;
  --| Purpose
  --|    Return the Water Temperature around the buoy.
  --|
  --| Notes
  --|    Update must be called to update the status
  --| of the buoy sensors first.

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Wind_Speed         .  SPEC
  -- .                                           .
  -- .............................................
  function Wind_Speed (ID : in BUOY_ID)
      return SPEED;
  --| Purpose
  --|    Return the Wind Speed around the buoy.
  --|
  --| Notes
  --|    Update must be called to update the status
  --| of the buoy sensors first.

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Global_Position    .  SPEC
  -- .                                           .
  -- .............................................
  function Global_Position (ID : in BUOY_ID)
      return LOCATION;
  --| Purpose
  --|    Return the location of the buoy.
  --|
  --| Notes
  --|    Update must be called to update the status
  --| of the buoy sensors first.

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Red_Light          .  SPEC
  -- .                                           .
  -- .............................................
  function Red_Light (ID : in BUOY_ID) return OFF_ON;
  --| Purpose
  --|    Indicate if the red light is on or off.
  --|
  --| Notes
  --|    Update must be called to update the status
  --| of the buoy sensors first.

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Yellow_Light       .  SPEC
  -- .                                           .
  -- .............................................
  function Yellow_Light (ID : in BUOY_ID) return OFF_ON;
  --| Purpose
  --|    Indicate if the yellow light is on or off.
  --|
  --| Notes
  --|    Update must be called to update the status
  --| of the buoy sensors first.

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Update             .  SPEC
  -- .                                           .
  -- .............................................
  procedure Update (ID : in BUOY_ID);
  --| Purpose
  --|    Update the buoy sensors' status.

end Buoy_Sensor_Interface;

