-- **************************************************
-- *                                                *
-- *  Spacecraft_Sensor_Interface                   *  SPEC
-- *                                                *
-- **************************************************
package Spacecraft_Sensor_Interface is

  type SPACECRAFT_SECTION is (BRIDGE, AUXILIARY_BRIDGE,
                              CREW_QUARTERS, GALLEY,
                              LAB1, LAB2, LAB3,
                              AIRLOCK1, AIRLOCK2,
                              EXPERIMENT_BAY);

  type PRESSURE is new FLOAT
      range 0.0 .. 400.0;          -- psi
  subtype TOLERATED_PRESSURE is PRESSURE
      range 20.0 .. 80.0;

  type TEMPERATURE is new FLOAT
      range -400.0 .. 2_000.0;     -- Fahrenheit
  subtype TOLERATED_TEMPERATURE is TEMPERATURE
      range -20.0 .. 120.0;

  type RADIATION_LEVEL is new FLOAT
      range 0.0 .. 8_000.0;        -- Roentgens
  subtype TOLERATED_RADIATION_LEVEL is RADIATION_LEVEL
      range 0.0 .. 400.0;

  -- .................................................
  -- .                                               .
  -- .  Spacecraft_Sensor_Interface.Sensed_Value     .  SPEC
  -- .                                               .
  -- .................................................
  function Sensed_Value
      (Location : in SPACECRAFT_SECTION) return PRESSURE;
  function Sensed_Value
      (Location : in SPACECRAFT_SECTION) return TEMPERATURE;
  function Sensed_Value
      (Location : in SPACECRAFT_SECTION) return RADIATION_LEVEL;
  --| Purpose
  --|    Return sensor readings from different parts of the
  --| spacecraft.
  --|
  --| Exceptions (none)
  --| Notes
  --|     If values exceed the limits set for the different
  --| types, the corresponding maximum or minimum values are
  --| returned.  Assume that sensor validation is performed
  --| internally to these routines.

  -- .................................................
  -- .                                               .
  -- .  Spacecraft_Sensor_Interface.Update           .  SPEC
  -- .                                               .
  -- .................................................
  procedure Update;
  --| Purpose
  --|     Examine each sensor and update its status.  This
  --| update includes sensor input validation.
  --|
  --| Exceptions (none)
  --| Notes
  --|     Update must be called before calling any of the
  --| Sensed_Value routines.  Update checks all sensors, so
  --| the scenario is to call Update and then call all the
  --| permutations of the Sensed_Value routines before
  --| calling Update again.

end Spacecraft_Sensor_Interface;

