with Cruise; use Cruise;
with Automobile_Interface; use Automobile_Interface;
with Console; use Console;
-- **************************************************************
-- *                                                            *
-- *  Main                  									*  SPEC
-- *															*
-- **************************************************************
procedure Main is
--|  Purpose
--|  Executable procedure which uses package Cruise in order
--|  to implement an automobile cruise control program.
--|
--|  Procedure Main uses two tasks, Control and Fetch.  
--|	
--|  Task Control initializes the terminal, prints the menu, determines
--|  whether the user or the cruise control is regulating 
--|  automobile speed, and continually updates the dashboard.
--|
--|  Task Fetch retrieves the user command and updates the
--|  appropriate global variables to update current program
--|  status.

--...............................................................
--.																.
--.  Task : Fetch												.
--.																.
--...............................................................
task Fetch;				-- task specification
task body Fetch is 		-- task body
begin
	while (not quit) loop
		quit := Fetch_Key;
	end loop;
end Fetch;				-- end task body

--...............................................................
--.																.
--.  Task : Control												.
--.																.
--...............................................................
task Control;    		-- task specification
task body Control is 	-- task body
begin
	Set_Terminal(VT100);
	Erase_Display;
	Print_Menu;
	while (not quit) loop
		if key /= 'l' then
			Determine_Control;
		end if;
		Update_Dashboard;
		Update;
		delay 0.3;
	end loop;
end Control;			-- end task body

-- **************************************************************
-- *                                                            *
-- *  Main                  									*  BODY
-- *															*
-- **************************************************************
--|  Tasks Control and Fetch begin execution upon call of Main.

begin
	null;
end Main;
