#define HEADER "C++ Problem 3.3 by Rick Conn using Borland C++"

#include <stdio.h>
#include <string.h>  // for strcpy()
#include <mem.h>     // for memcpy()

class note {
  char text[40];
public:
  note (char *cp = "");
  void print (void);
};

class note_book {
  note *narray[10];
  int number_of_notes;
public:
  note_book();
  void add (note *);
  void print(void);
};

note::note (char *value) { strcpy(text, value); }

void note::print(void) { printf("Note: %s\n", text); }

note_book::note_book() { number_of_notes = 0; }

void note_book::add (note *newnote) {
  narray[number_of_notes] = newnote;
  number_of_notes++;
}

void note_book::print(void) {
  int i;

  for (i=0; i<number_of_notes; i++) {
    printf("%2d: ", i);
    narray[i] -> print();
  }
}

void main(void)
{
  printf("%s\n", HEADER);

  note_book nb;

  note n1("This is a test");     note n2("This is only a test");
  note n3("How far will I go?"); note n4("Perhaps just so far");
  note n5("This is fun");        note n6("This is boring");
  note n7("This works");

  nb.add (&n1);  nb.add (&n2);  nb.add (&n3);  nb.add (&n4);
  nb.add (&n5);  nb.add (&n6);  nb.add (&n7);

  nb.print();
}
