#define HEADER "C++ Problem 5.4 by Rick Conn using Borland C++"

#include <stdio.h>

// COMPLEX Class
class complex {
  float real_part;
  float imag_part;
  char *name;
public:
  complex (char *, float rp=0.0, float ip=0.0);
  void set (float rp=0.0, float ip=0.0);
  complex & operator= (complex &);
  complex operator+ (complex &right);
  complex operator- (complex &right);
  complex operator* (complex &right);
  void print(void);
};

complex::complex (char *n, float rp, float ip) {
  name = n;  real_part = rp;  imag_part = ip;
}

void complex::set (float rp, float ip) {
  real_part = rp;  imag_part = ip;
}

complex & complex::operator= (complex &arg) {
  real_part = arg.real_part;
  imag_part = arg.imag_part;
  return *this;
}

complex complex::operator+ (complex &right) {
  complex result ("Temp");
  result.real_part = real_part + right.real_part;
  result.imag_part = imag_part + right.imag_part;
  return result;
}

complex complex::operator- (complex &right) {
  complex result ("Temp");
  result.real_part = real_part - right.real_part;
  result.imag_part = imag_part - right.imag_part;
  return result;
}

complex complex::operator* (complex &right) {
  complex result ("Temp");
  result.real_part = real_part * right.real_part -
                     imag_part * right.imag_part;
  result.imag_part = imag_part * right.real_part +
                     real_part * right.imag_part;
  return result;
}

void complex::print(void) {
  printf("  %s: %10.5f + %10.5fi\n",
          name, real_part, imag_part);
}

void main(void)
{
  printf("%s\n", HEADER);

  complex a("A"), b("B", 2.0, 3.0), c("C");

  a = b;
  printf("A = B\n");
  a.print(); b.print(); c.print();
  a.set(5.0, -4.0);
  printf("A = 5 - 4i\n");
  a.print(); b.print(); c.print();
  c = a + b;
  printf("C = A + B\n");
  a.print(); b.print(); c.print();
  c = a - b;  
  printf("C = A - B\n");
  a.print(); b.print(); c.print();
  c = a * b;
  printf("C = A * B\n");
  a.print(); b.print(); c.print();
}
