/*********************************************************
  Kohonen Network Plotting Program
  Written by Maureen Caudill 
  in Lightspeed C on a Macintosh
  
 See the August, 1988 AI Expert, Neural Network Primer, Part 4 
  for a discussion of this network.
  
  This program takes the output from Kohonen Feature Map.c and
  generates feature maps on a Macintosh screen.
  
  Note, you MUST run Kohonen.c prior to running this program.
  The data files required for this program are generated by
  running the feature map program; only after they are generated
  can the topological maps be drawn.
  
  The program looks for the specified data files, and, one at
  at time, draws the feature map for that file.  To go to the
  next file, press RETURN.  The feature map program generates 
  20 data files, every 100 input patterns.  This simple program
  does not label the screen.  Note that the axes are precisely
  one unit long in each direction.
  
  ****MACINTOSH SPECIFIC PROGRAM;  NOT USABLE ELSEWHERE!!***
  
  ****ALSO, NOTE THAT THE DISPLAY IN THIS PROGRAM HAS BEEN ****
  ****SCALED FOR OPERATION ON A MacII 13 INCH MONITOR.  ON ****
  ****A REGULAR MACINTOSH, YOU MUST CHANGE THE SCALING     ****
  ****PARAMETERS AS INDICATED BELOW TO SEE THE ENTIRE SCREEN ****
  
  Adaptics
  16776 Bernardo Center Drive, Suite 110B
  San Diego, CA  92128
  (619) 451-3752
 
  *********************************************************/
#include   <math.h>			/*needed for floating point and math functions*/
#include   <stdio.h>		/* gives fopen, fclose, printf functions */
 #include "WindowMgr.h"
 #include "EventMgr.h"
 #include "QuickDraw.h"
 
#define    	NUMROWS     10 			/* number of neurodes = NUMROWS*NUMCOLS */
#define   	NUMCOLS     10
#define    	PATSIZE     2 			/* keep input size small for easy plotting */
#define		NUMITERS  	500		 	/* total iterations to run */
#define    	SAVECOUNT  	50  		/* when to save net (about 0.1*NUMITERS) */
#define    	ADJNBORS  	100  		/* how often to lower neighborhood size */ 

/**** change the following parameters if not using a 13 inch Mac screen ****/
#define		WINDHEIGHT  500         /* if regular MAC, this should be about 300 */
#define     WINDWIDTH	500         /* if regular MAC, this should be about 300 */
#define		BORDER		50			/* this puts a 50 pixel border within window, allowing
             						   room for menu bar at top and a margin all around */
/*-----------------------------------------------------------------------------------------------------------
   Global storage
-------------------------------------------------------------------------------------------------------------*/
int		intwts[NUMROWS][NUMCOLS][PATSIZE]			; /* integer-converted weights */
int		count;
FILE	*fopen(),*savefile							; /* output file to save network state */
char	*strcpy();
char	*strcat();
char  *savepath,
	  *savepath0 = "Kohonen Iter 0",
	  *savepath1 = "Kohonen Iter 100",
	  *savepath2 = "Kohonen Iter 200",
	  *savepath3 = "Kohonen Iter 300",
	  *savepath4 = "Kohonen Iter 400",
	  *savepath5 = "Kohonen Iter 500",
	  *savepath6 = "Kohonen Iter 600",
	  *savepath7 = "Kohonen Iter 700",
	  *savepath8 = "Kohonen Iter 800",
	  *savepath9 = "Kohonen Iter 900",
	  *savepath10 = "Kohonen Iter 1000",
	  *savepath11 = "Kohonen Iter 1100",
	  *savepath12 = "Kohonen Iter 1200",
	  *savepath13 = "Kohonen Iter 1300",
	  *savepath14 = "Kohonen Iter 1400",
	  *savepath15 = "Kohonen Iter 1500",
	  *savepath16 = "Kohonen Iter 1600",
	  *savepath17 = "Kohonen Iter 1700",
	  *savepath18 = "Kohonen Iter 1800",
	  *savepath19 = "Kohonen Iter 1900",
	  *savepath20 = "Kohonen Iter 2000";
	
	  
		
/*--------------------------------------------------------------------------------------------------

	READ_DATA(iteration)
	This routine will read the current state of the weight 
	vectors from a file so they can later be plotted.
	The format of the data file is:
	
	Iteration number
	neurode 0,0 weights 
	neurode 0,1 weights
	neurode 0,2 weights
	...
	neurode 1,0 weights
	...
	neurode 9,9 weights
	Iteration number
	...
	The routine or program reading this file must be told the
	number of neurodes in each row and column of the network,
	and the number of elements in the input pattern.
	
-----------------------------------------------------------------------------------------------------*/
read_data()
{
	int		row, col, wt;
	char		*strcpy();
	char		*strcat();
	char		digits;
	char		itoa();
	float		weight1,weight2,xscale,yscale,xoffset,yoffset;
	int			readcount;
	
	savefile = fopen(savepath,"r");     	/* open an input text file */
	if (savefile == NULL)
	{
		printf("\n Error in opening file");
		return;
	}
	xscale = (float) (WINDWIDTH/2 - BORDER);		/* scaling factor for width */
	yscale = (float) (WINDHEIGHT/2 - BORDER);       /* scaling factor for height */
	xoffset = (float) (WINDWIDTH/2);                /* offset to X origin */
	yoffset = (float) (WINDHEIGHT/2);               /* offset to Y origin */
	readcount = fscanf(savefile,"\n Iteration count %d",&count);   /* iteration count */

	for (row=0; row<NUMROWS; row++)
	{
		for (col=0; col<NUMCOLS; col++)
		{
				fscanf(savefile,"%f %f",&weight1, &weight2);
				weight2 = -weight2;  /* flip because vertical grows down on screen */
				intwts[row][col][0] = (int)(xscale * weight1 + xoffset);
				intwts[row][col][1] = (int)(yscale * weight2 + yoffset);
		}  /* end for each neurode in column */
	}  /* end for each neurode in row */
	fclose(savefile);
	return;
}

 /*------------------------------------------------------------------
 
 	Main program
 	
 --------------------------------------------------------------------*/
main()
{
 	WindowPtr myWindow, whichWindow;
 	EventRecord	myEvent;
 	static Rect bounds = {0,0,WINDWIDTH,WINDHEIGHT};
 	int			row, col, pat,done,xleft,xright,ytop,ybottom,xcenter,ycenter;
 	int			scale, figureLeft, figureTop,length;
 	int			filecount,code,count;
	
	for (filecount=0; filecount<21; filecount++)
	{
		switch (filecount)
		{
		case 0:  savepath= savepath0; break;
		case 1:  savepath= savepath1; break;
		case 2:  savepath= savepath2; break;
		case 3:  savepath= savepath3; break;
		case 4:  savepath= savepath4; break;
		case 5:  savepath= savepath5; break;
		case 6:  savepath= savepath6; break;
		case 7:  savepath= savepath7; break;
		case 8:  savepath =savepath8; break;
		case 9:  savepath= savepath9; break;
		case 10:  savepath = savepath10; break;
		case 11:  savepath= savepath11; break;
		case 12:  savepath= savepath12; break;
		case 13:  savepath= savepath13; break;
		case 14:  savepath= savepath14; break;
		case 15:  savepath= savepath15; break;
		case 16:  savepath= savepath16; break;
		case 17:  savepath= savepath17; break;
		case 18:  savepath =savepath18; break;
		case 19:  savepath= savepath19; break;
		case 20:  savepath = savepath20; break;
	
		default:	savepath=savepath20;break;
		}

		read_data();
	
 		InitGraf(&thePort);
		InitFonts();
	 	InitWindows();
	 	InitCursor();
	 	TextFont(3);         /* In most systems this should be Geneva font */
 
  		xleft = BORDER;
 		ytop  = BORDER;
 		xcenter = WINDWIDTH/2;
 		ycenter = WINDHEIGHT/2;
 		xright = WINDWIDTH-BORDER;
 		ybottom = WINDHEIGHT-BORDER;
	
 		myWindow = NewWindow(0,&bounds, "\pClick close box or Return",1,0,-1,1,0);
	
		/*SetOrigin (-xcenter, -ycenter);*/   /*offset origin to window location */
 
 		/* draw X-Y axes */
 		MoveTo(xleft,ycenter);  /* Starting 50 pixels from top leaves room for menu bar */
 		LineTo(xright,ycenter);
 		MoveTo(xcenter,ytop);
 		LineTo(xcenter,ybottom);

		/* draw the topology map */
		for (row = 0; row<NUMROWS; row++)
		{	
			MoveTo(intwts[row][0][0], intwts[row][0][1]);
			for (col=1; col<NUMCOLS; col++)
			{
				LineTo (intwts[row][col][0],intwts[row][col][1]);
			}
		}
	
		for (col = 0; col<NUMCOLS; col++)
		{
			MoveTo(intwts[0][col][0], intwts[0][col][1]);
			for (row=1; row<NUMROWS; row++)
			{
				LineTo (intwts[row][col][0], intwts[row][col][1]);
			}
		}
		
		MoveTo(xcenter-10,ybottom+20);   /* almost centered, just below diagram */
		count = filecount;
		if (count>=10)
		{
			code = count/10 + 48;       /* make code = ascii code for digit */
			DrawChar(code);
			count -= 10*(code-48);
		}
		code = count + 48;              /* make code = ascii code for digit */
		DrawChar(code);
		DrawChar('0');
		DrawChar('0');
		done = FALSE;
 		while (done!=TRUE ) 
 		{
 			GetNextEvent(everyEvent, &myEvent);
 			if ( (myEvent.what == mouseDown  
 					&& FindWindow(myEvent.where, &whichWindow) == inGoAway
 					&& whichWindow == myWindow
 					&& TrackGoAway (myWindow, myEvent.where) )
 				|| myEvent.what == keyDown)
 				{
 					HideWindow(myWindow);
 					DisposeWindow(myWindow);
 					done = TRUE;	
 				}
 			else
 				done = FALSE;
 		}
 		
 	}
 	return;
 }                                                      