Unit AIMATH;

interface

uses aiglob;


Function Mean(ImagData : ImagType2;x1,x2 : word):double;
Function StDev(ImagData : ImagType2;x1,x2:word;tMean:double):double;
Function Mean2(imagdata:imagtype2;x1,x2:word):double;
Function Max(A,B:word):word;
Function Min(A,B:word):word;
Function MaxMinRatio(A,B : double):double;
Function Kurtosis(imagdata : imagtype2;count,mode:word):double;
Function Skewness(imagdata : imagtype2;count,mode:word):double;

Implementation



{---------------------------------------------------------------------}

Function Max(A,B:word):word;
begin
  If A > B then
    Max := A
  else
    Max := B;
end;

Function Min(A,B:word):word;
begin
  If A < B then
    Min := A
  else
    Min := B;
end;

Function MaxMinRatio(A,B:double):double;
begin
  If A < B then
    MaxMinRatio := B/A
  else
    MaxMinRatio := A/B;
end; {end function MaxMinRatio}

Function mean2(imagdata:Imagtype2;x1,x2:word):double;

function addit2(imagdata:imagtype2;x1,x2:word):word;
begin
inline($8b/$5e/<x2/                {mov bx,x2}
       $8b/$fb/                    {mov di,bx}
       $2b/$5e/<x1/                {sub bx,x1}
       $8b/$cb/                    {mov cx,bx}
       $d1/$e7/                    {shl di,1}
       $8b/$83/$74/$ec/            {mov ax,word ptr [bp+di-138ch]}
       $4f/                        {again: dec di}
       $4f/                        {dec di}
       $03/$83/$74/$ec/            {add ax,word ptr [bp+di-138ch]}
       $e2/$f8/                    {loop again}
       $89/$46/$fe);               {mov [bp-02],ax}
  end;

function divide(number,i : double):double;
begin
inline($dd/$46/$f0/
       $dc/$76/$e8/
       $dd/$5e/$f8);
end;

begin
  mean2 := divide(addit2(imagdata,x1,x2),x2-x1+1);
end;
{-----------------------------------------------------------------}

Function Mean(ImagData : ImagType2;x1,x2 : word):double;
Var
   i        : word;
   meantemp : double;
begin
   meantemp := 0;

   for i := x1 to x2 do
     MeanTemp := ImagData[i] + MeanTemp;

   If (x2-x1+1) <> 0 then
      Mean := MeanTemp/(x2-x1+1)
   else
      Mean := 0;
end;

Function MySqrt(NumIn:double):double;
begin
inline($dd/$46/$f0/       {fld}
       $d9/$fa/           {fsqrt}
       $dd/$5e/$f8);      {fstp}
end;

Function StDev(ImagData : ImagType2;x1,x2:word;tMean:double):double;
Var
   i      : word;
   StTemp : double;
begin
  StTemp := 0;
  For i := x1 to x2 do
   StTemp := sqr(ImagData[i] - tMean) + StTemp;
  If (x2-x1 > 0) then
    StDev := Sqrt((StTemp)/(x2-x1))
  else
     StDev := 0;
end;

Function Kurtosis(imagdata : imagtype2;count,mode:word):double;
Var
   _mean,_st : double;
   sum,temp  : double;
   i         : word;
begin
  _mean := mean(imagdata,1,count);
  _st   := stdev(imagdata,1,count,_mean);
  sum := 0;
  For i := 1 to count do
  begin
    temp := (imagdata[i] - _mean);
    temp := temp*temp*temp*temp;
    sum  := sum + temp;
  end;
  temp := _st*_st*_st*_st;
  If count*temp <> 0 then
     Kurtosis := (sum/(count*temp)) - 3
  else
     Kurtosis := 0;
end;

Function Skewness(imagdata : imagtype2;count,mode:word):double;
Var
   _mean,_st : double;
   sum,temp  : double;
   i         : word;
   sum1,sum2,sum3 : double;
begin
  sum1 := 0;
  sum2 := 0;
  sum3 := 0;
  _mean := mean(imagdata,1,count);
  _st   := stdev(imagdata,1,count,_mean);

  sum := 0;

 For i := 1 to count do
  begin
    temp := (imagdata[i] - _mean);
    temp := temp*temp*temp;
    sum  := sum + temp;
  end;
  temp := _st*_st*_st;
  If count*temp <> 0 then
     Skewness := (sum/(count*temp))
  else
     Skewness := 0;

  {
  for i := 1 to count do
  begin
    sum1 := imagdata[i] + sum1;
    sum2 := (sqr(imagdata[i])) + sum2;
    sum3 := sum3 + (imagdata[i]*imagdata[i]*imagdata[i]);
  end;
  sum := ( (sum3 - (3*_mean*sum2) + (3*_mean*_mean*sum1) )/count );
  sum := sum - (_mean*_mean*_mean);
  sum := sum/(_st*_st*_st);
  skewness := sum;     }

end;

END.