@echo off
echo off
goto top

LHC.BAT v.1.5
LHarc-Convert batch file
May 19, 1990

By RBLevin
P.O. Box 14546
Phila., PA 19115

Lab:  (215) 333-8274
BBS:  (215) 333-8275

Converts .ARC, .ZIP, .ZOO and self-extracting archives to .LZH format

Notes:  (1)  ARC.EXE, LHARC.EXE, PKUNZIP.EXE and ZOO.EXE must be stored in a
                subdirectory specified in the PATH environment variable.

        (2)  The new .LZH files will be stored in the \LZH\NEW subdirectory.

        (3)  The old archive files will remain in their original storage
                locations.

        (4)  Backup copies of the old archive files will be stored in the
                \LZH\OLD subdirectory.

        (5)  The \LZH subdirectory must be empty before invoking LHC.

:top
   rem check invocation syntax
   rem
   if (%2) == () goto sntxerr

   rem if work directories don't exist then make them
   rem (ctty supresses "unable to create directory" messages generated when
   rem the target directory already exists -- redirecting to nul with > doesn't
   rem work)
   rem
   ctty nul
   md \lzh
   md \lzh\new
   md \lzh\old
   ctty con

   rem if \lzh directory is not empty then jump to :sntxerr
   rem
   if exist \lzh\*.* goto sntxerr

   rem copy target file to \lzh directory
   rem
   copy %1 \lzh

   rem change to \lzh directory
   rem
   cd \lzh

   :arc    
      rem if target file is not an .arc file then jump to :com
      rem
      if not exist *.arc goto com

      rem else extract the .arc file to the \lzh directory
      rem
      arc x %1

      rem and jump to :lzh
      rem
      goto lzh

   :com
      rem if target file is not a .com file then jump to :exe
      rem
      if not exist *.com goto exe

      rem else extract the .com file to the \lzh directory
      rem
      %1

      rem and jump to :lzh
      rem
      goto lzh

   :exe
      rem if target file is not an .exe file then jump to :zip
      rem
      if not exist *.exe goto zip

      rem else extract the .exe file to the \lzh directory
      rem
      %1

      rem and jump to :lzh
      rem
      goto lzh

   :zip
      rem if target file is not a .zip file then jump to :zoo
      rem
      if not exist *.zip goto zoo

      rem else extract the .zip file to the \lzh directory
      rem
      pkunzip %1

      rem and jump to :lzh
      rem
      goto lzh

   :zoo
      rem if target file is not a .zoo file then jump to :xit
      rem
      if not exist *.zoo goto xit

      rem else extract the .zip file to the \lzh directory and fall to :lzh
      rem
      zoo x %1

:lzh
   rem move target file to \lzh\old directory
   rem
   copy %1 \lzh\old

   rem delete target file from \lzh directory
   rem
   del \lzh\%1

   rem lharc preserving original file creation date
   rem
   lharc a /t %2 *.*

   rem move new lharc file to the \lzh\new directory
   rem
   copy *.lzh \lzh\new

   rem delete all files from the \lzh directory
   rem
   echo y | del \lzh

   rem split
   rem
   goto xit

:sntxerr
   rem print syntax error message
   rem
   echo Syntax is LHC [old archive filename] [new archive filename]

   rem if \lzh directory is not empty then print additional error message
   rem
   if exist \LZH\*.* echo The \LZH subdirectory must be empty before invoking LHC

:xit

rem end of lhc.bat
