include	asm.inc

public	syshard
extrn	isems:proc, ismouse:proc, isherc:proc
extrn	floppies:proc, floppytype:proc
extrn	getkey:proc, getcrt:proc
extrn	getcpu:proc, mathchip:proc
extrn	wclear:proc, wframe:proc, tprint:proc

.data
notinstalled	db 'Not installed',0
f360		db '360 kb drive',0
f12		db '1.2 Mb drive',0
f720		db '720 kb drive',0
f14		db '1.4 Mb drive',0

drive_table	dw notinstalled
		dw f360
		dw f12
		dw f720
		dw f14

i8086		db '8086 or 8088',0
i186		db '80186 or 80188',0
i286		db 'i286',0
i386		db '386',0
i486		db '486',0

cpu_table	dw i8086
		dw i186
		dw i286
		dw i386
		dw i486

no87		db 'none',0
mc8087		db '8087',0
mc287		db '287',0
mc387		db '387',0
mc487		db '487',0

mathchip_table	dw no87
		dw mc8087
		dw mc287
		dw mc387
		dw mc487

; window corner data
r0	dw 3
c0	dw 15
r1	dw 3+number_of_labels+1
c1	dw 54
window_color	db 0Ch		; bright red, black background
text_color	db 07h

cga	db 'CGA',0
mda	db 'Monochrome text',0
ega	db 'EGA',0
mcga	db 'MCGA',0
vga	db 'VGA',0
Herc	db 'Hercules',0
RamFont	db 'Hercules RAMFont',0
InColor	db 'Hercules InColor',0

screen_table	dw cga
		dw mda
		dw ega
		dw mcga
		dw vga
		dw herc
		dw ramfont
		dw incolor

; labels
labels	db 'CPU:          ',0
size_of_label	equ $-labels
	db '80x87:        ',0
;	db 'RAM:          ',0
	db 'EMS:          ',0
	db 'Drive A:      ',0
	db 'Drive B:      ',0
	db 'Mouse:        ',0
	db 'Screen:       ',0
number_of_labels	equ ($-labels)/size_of_label

isinstalled	db 'installed and active',0

mouse_installed	db '  buttons',0

.code
syshard	proc
; clear a window for the system info
	lea	bx,r0
	mov	ah,window_color
	call	wclear
	mov	al,-1		; double-lined window frame
	call	wframe

; print labels at left side of window
	mov	cx,number_of_labels
	mov	dh,byte ptr r0
	mov	dl,byte ptr c0
	inc	dl
	lea	si,labels
	mov	ah,text_color
label_loop:
	inc	dh
	call	tprint
	add	si,size_of_label
	loop	label_loop

; determine CPU type
	call	getcpu
	mov	bx,ax
	shl	bx,1
	mov	si,cpu_table[bx]
	mov	dh,byte ptr r0
	inc	dh
	mov	dl,byte ptr c0
	add	dl,size_of_label
	mov	ah,text_color
	call	tprint

; math coprocessor
	call	mathchip
	mov	bx,ax
	shl	bx,1
	mov	si,mathchip_table[bx]
	inc	dh
	mov	ah,text_color
	call	tprint

; installed RAM
; I haven't done this yet
;	inc	dh

; EMS memory
	inc	dh
	call	isems
	lea	si,notinstalled
	jc	print_ems
	lea	si,isinstalled
print_ems:
	mov	ah,text_color
	call	tprint

; floppy drive types
	mov	cl,0		; start with drive A:
next_floppy:
	push	dx		; save screen coordinates
	mov	dl,cl		; drive number
	call	floppytype
	pop	dx		; screen coordinates
	or	ax,ax		; AX = 0 if bad drive number
	jz	no_more_floppies
	inc	dh		; next row on screen
	mov	bx,ax		; drive ID
	shl	bx,1		; convert to offset
	mov	si,drive_table[bx]
	mov	ah,text_color
	call	tprint
	inc	cl		; next drive
	jmp	next_floppy
no_more_floppies:

; Mouse
	inc	dh
	call	ismouse
	lea	si,notinstalled
	or	ax,ax
	jz	print_mouse
	lea	si,mouse_installed
	add	al,'0'		; convert to ASCII
	mov	[si],al
print_mouse:
	mov	ah,text_color
	call	tprint

; Screen
	inc	dh
	call	getcrt
	inc	ax
	mov	bx,ax
	cmp	ax,129
	jb	print_screen
	mov	bx,5
	je	print_screen
	cmp	ax,209		; InColor?
	inc	bx
	jb	print_screen
	inc	bx
print_screen:
	shl	bx,1
	mov	si,screen_table[bx]
	mov	ah,text_color
	call	tprint

	call	getkey
	ret
syshard	endp
	end
