comment	|

	This program demonstrates how to read this program's copy of the
	parent's environment created by COMMAND.COM ... For DOS Ver 3.x, the
	fully justified path name of this program will also be displayed.

	The environment consists of null-terminated ASCII strings (ASCIIZ),
	with the entire list terminated by another null. A 2-byte entry at
	offset 2Ch in the program's program segment prefix (PSP) contains the
	segment of the copy of the environment. The code commenting, wording
	of printing messages and some of the code itself have been changed in
	a number of places.

	Written for MASM 5.0 by Hardin Brothers for PCResource. The original
	appeared in the April 1988 issue of their magazine. Entire contents of
	the April 1988 issue (C) Copyright 1988 by
				IDG Communications/Peterborough, Inc.

	Hardin Brothers is a freelance programmer and technical writer. Write
	to him at 280 N. Campus Ave., Upland, CA  91786. Enclose a self-
	addressed, stamped envelope for a reply.

	|

LF	equ	0Ah	; linefeed char
CR	equ	0Dh	; carriage return char
STDOUT	equ	1	; standard output device

EXIT	macro	val
	mov	AH, 4Ch		; INT 21h service 4Ch: exit from program
				; also returns a value. replaces old INT 20h.
	mov	AL, val		; return value byte
	int	21h
	endm

	.MODEL	SMALL
	.STACK

	.CODE

start:	cld			; clear direction flag:
				;   search from lowmem to highmem
	mov	DS, ES:[2Ch]	; point DS to environment copy
	mov	ES, ES:[2Ch]	; point ES there, too
	mov	AH, 02h		; INT 21h service 02h: write a char to stdout
	mov	DL, CR
	int	21h
	mov	AH, 02h
	mov	DL, LF
	int	21h
	mov	DI, 0		; set pointer offset from ES
	mov	CX, 7FFFh	; max. environment size = 32768 bytes
	mov	BX, STDOUT	; write to standard output device

lp:	test	byte ptr ES:[DI], 0FFh	; test for end of list
	jz	cmd_nam		; skip to cmd_nam if so
	sub	AL, AL		; set AL = 0
	mov	DX, DI		; put start offset in DX
	repne	scasb		; search for null char
	push	CX		; save byte count
	mov	CX, DI		; get tail + 1
	sub	CX, DX		; set CX to string length
	mov	AH, 40h		; INT 21h service 40h: write to file/device
	int	21h
	mov	AH, 02h
	mov	DL, CR
	int	21h
	mov	AH, 02h
	mov	DL, LF
	int	21h
	pop	CX		; restore byte count
	jmp	lp		; continue search

cmd_nam:
	mov	AH, 30h		; INT 21h service 30h: get DOS version number
	int	21h
	cmp	AL, 3		; is this Ver 3.x ?
	jb	endit		; skip to endit if not
	inc	DI		; addr ES:DI points to word 0001h flag

	cmp	word ptr ES:[DI], 1	; check flag value
	jne	endit		; skip to endit if unflagged
	add	DI, 2		; addr ES:DI points to head of name
	mov	DX, DI		; save addr of head
	sub	AL, AL		; set AL = 0
	mov	CX, 0FFh	; set search until end
	repne	scasb		; search for null char
	mov	CX, DI		; get addr of tail
	sub	CX, DX		; set CX to string length
	mov	BX, STDOUT	; write to stdout
	mov	AH, 40h
	int	21h

endit:	mov	AH, 02h
	mov	DL, CR
	int	21h
	mov	AH, 02h
	mov	DL, LF
	int	21h
	EXIT	0		; normal termination

	end	start

