;
; *** Listing 10-12 ***
;
; Clears a 1000-byte block of memory via BlockClear64,
; which handles blocks between 1 and 64K bytes in
; length. BlockClear64 gains the ability to handle
; 64K blocks by using STOSW rather than STOSB to
; the greatest possible extent, getting a performance
; boost in the process.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
ByteArray	db	ARRAY_LENGTH dup (?)
;
; Clears a block of memory CX bytes in length. A value
; of 0 means "clear 64K bytes," so the maximum length
; that can be cleared is 64K bytes and the minimum length
; is 1 byte.
;
; Input:
;	CX = number of bytes to clear
;	ES:DI = start of block to clear
;
; Output:
;	none
;
; Registers altered: AX, CX, DI
;
; Direction flag cleared
;
BlockClear64:
	sub	ax,ax	;fill with zero a word at a time
	stc		;assume the count is zero-setting
			; the Carry flag will give us 8000h
			; after the RCR
	jcxz	DoClear	;the count is zero
	clc		;it's not zero
DoClear:
	rcr	cx,1	;divide by 2, copying the odd-byte
			; status to the Carry flag and
			; shifting a 1 into bit 15 if and
			; only if the count is zero
	cld		;make STOSW move DI up
	rep	stosw	;clear the block
	jnc	ClearDone
			;the Carry status is still left over
			; from the RCR. If we had an even #
			; of bytes, we're done
	stosb		;clear the odd byte
ClearDone:
	ret
;
Skip:
	call	ZTimerOn
	mov	di,seg ByteArray
	mov	es,di	;point ES:DI to the array to clear
	mov	di,offset ByteArray
	mov	cx,ARRAY_LENGTH	;# of bytes to clear
	call	BlockClear64	;clear the array
	call	ZTimerOff
