;
; *** Listing 10-13 ***
;
; Clears a 1000-byte block of memory via BlockClearW,
; which handles blocks between 0 and 64K-1 bytes in
; length. BlockClearW uses STOSW rather than STOSB to
; the greatest possible extent in order to improve
; performance.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
ByteArray	db	ARRAY_LENGTH dup (?)
;
; Clears a block of memory CX bytes in length. A value
; of 0 means "clear zero bytes," so the maximum length
; that can be cleared is 64K-1 bytes and the minimum
; length is 0 bytes.
;
; Input:
;	CX = number of bytes to clear
;	ES:DI = start of block to clear
;
; Output:
;	none
;
; Registers altered: AX, CX, DI
;
; Direction flag cleared
;
BlockClearW:
	sub	ax,ax	;we'll fill with the value 0
	shr	cx,1	;divide by 2, copying the odd-byte
			; status to the Carry flag
	cld		;make STOSW move DI up
	rep	stosw	;clear the block
	jnc	ClearDone
			;the Carry status is still left over
			; from the SHR. If we had an even #
			; of bytes, we're done
	stosb		;clear the odd byte
ClearDone:
	ret
;
Skip:
	call	ZTimerOn
	mov	di,seg ByteArray
	mov	es,di	;point ES:DI to the array to clear
	mov	di,offset ByteArray
	mov	cx,ARRAY_LENGTH	;# of bytes to clear
	call	BlockClearW	;clear the array
	call	ZTimerOff
