;
; *** Listing 10-14 ***
;
; Generates the 8-bit checksum of a 1000-byte array
; using LODS with an ES: override.
;
	jmp	Skip
;
FarSeg	segment	para
ARRAY_LENGTH	equ	1000
ByteArray	db	ARRAY_LENGTH dup (0)
FarSeg	ends
Skip:
	call	ZTimerOn
	mov	si,seg ByteArray
	mov	es,si	;point ES:SI to the array to
			; checksum
	mov	si,offset ByteArray
	mov	cx,ARRAY_LENGTH	;# of bytes to checksum
	sub	ah,ah	;zero the checksum counter
	cld		;make LODS move the pointer up
ChecksumLoop:
	lods	byte ptr es:[si]
			;get the next byte to checksum
	add	ah,al	;add the byte into the checksum
	loop	ChecksumLoop
	call	ZTimerOff
