;
; *** Listing 13-1 ***
;
; Generates the cumulative exclusive-or of all bytes in a
; 64-byte block of memory by using the LOOP instruction to
; repeat the same code 64 times.
;
	jmp	Skip
;
; The 64-byte block for which to generate the cumulative
; exclusive-or.
;
X=1
ByteArray	label	byte
	rept	64
	db	X
X=X+1
	endm
;
; Generates the cumulative exclusive-or of all bytes in a
; 64-byte memory block.
;
; Input:
;	SI = pointer to start of 64-byte block for which to
;		calculate cumulative exclusive-or
;
; Output:
;	AH = cumulative exclusive-or of all bytes in the
;		64-byte block
;
; Registers altered: AX, CX, SI
;
CumulativeXor:
	cld
	sub	ah,ah	;initialize our cumulative XOR to 0
	mov	cx,64	;number of bytes to XOR together
XorLoop:
	lodsb		;get the next byte and
	xor	ah,al	; XOR it into the cumulative result
	loop	XorLoop
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset ByteArray
				;point to the 64-byte block
	call	CumulativeXor	;get the cumulative XOR
	call	ZTimerOff
